\name{rome_iv_infant_functional_diarrhea}
\alias{rome_iv_infant_functional_diarrhea}
\title{
Rome IV Diagnostic Criteria for Infant Functional Diarrhea
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Infant Functional Diarrhea** (also known as toddler's diarrhea). This diagnosis is characterized by chronic, painless, loose or watery stools without evidence of growth failure or other illness, occurring in children typically between 6 and 36 months of age.
}
\usage{
rome_iv_infant_functional_diarrhea(age_lt_36mo, three_or_more_stools_daily,
                                   loose_watery_stool, symptom_onset_ge_4_weeks,
                                   no_failure_to_thrive, no_illness_explanation)
}
\arguments{
  \item{age_lt_36mo}{
Numeric (0 or 1). Is the child between 6 and **36 months of age**? (1 = Yes).
}
  \item{three_or_more_stools_daily}{
Numeric (0 or 1). Does the child pass at least **three stools daily**? (1 = Yes).
}
  \item{loose_watery_stool}{
Numeric (0 or 1). Are the stools **loose or watery** (Bristol Stool Form Scale 6 or 7)

[Image of bristol stool scale chart]
? (1 = Yes).
}
  \item{symptom_onset_ge_4_weeks}{
Numeric (0 or 1). Have symptoms been present for at least **4 weeks**? (1 = Yes).
}
  \item{no_failure_to_thrive}{
Numeric (0 or 1). Is there **no** evidence of **failure to thrive** (e.g., poor weight gain)? (1 = Yes). This is a required exclusion.
}
  \item{no_illness_explanation}{
Numeric (0 or 1). Is there **no** other organic illness or explanation for the diarrhea? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Infant Functional Diarrhea" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met (Toddler's Diarrhea)
# Age 24mo, 4 stools/day, Loose stools, Duration 6 weeks, Normal growth, No other cause
rome_iv_infant_functional_diarrhea(1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Failure to Thrive)
# All criteria met, but child is failing to thrive (0 for no_failure_to_thrive)
rome_iv_infant_functional_diarrhea(1, 1, 1, 1, 0, 1)
}
