\name{rome_iv_functional_dysphagia}
\alias{rome_iv_functional_dysphagia}
\title{
Rome IV Diagnostic Criteria for Functional Dysphagia
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Dysphagia. Diagnosis requires persistent difficulty swallowing (dysphagia), typically for solids only, that is non-odynophagic (not painful) and not explained by organic disease (structural, Eosinophilic Esophagitis, GERD, or major motility disorders). Symptoms must be chronic (onset >= 6 months, active >= 3 months).
}
\usage{
rome_iv_functional_dysphagia(non_odynophagia_dysphagia, swallowing_solids_only,
                             no_structural_obstruction, no_eosinophilic_esophagitis,
                             no_gerd, no_major_motility_disorder,
                             symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{non_odynophagia_dysphagia}{
Numeric (0 or 1). Presence of dysphagia that is non-odynophagic (not painful). (1 = Yes).
}
  \item{swallowing_solids_only}{
Numeric (0 or 1). Does the dysphagia occur primarily for solid foods, not liquids? (1 = Yes).
}
  \item{no_structural_obstruction}{
Numeric (0 or 1). Has structural obstruction (e.g., stricture, mass) been excluded by upper endoscopy? (1 = Yes).
}
  \item{no_eosinophilic_esophagitis}{
Numeric (0 or 1). Has Eosinophilic Esophagitis (EoE) been excluded? (1 = Yes).
}
  \item{no_gerd}{
Numeric (0 or 1). Has Gastroesophageal Reflux Disease (GERD) been excluded (e.g., negative pH monitoring, no response to PPI)? (1 = Yes).
}
  \item{no_major_motility_disorder}{
Numeric (0 or 1). Have major esophageal motility disorders (e.g., achalasia, spasm) been excluded by manometry? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Dysphagia" or "Criteria Not Met".}
}
\references{
Aben-Fawaz H, Kahrilas PJ, Chen J. Esophageal disorders. Gastroenterology. 2016;150:1367-1379. doi:10.1053/j.gastro.2016.02.002
}
\examples{

# Example 1: Diagnosis Met
# All exclusion criteria and symptom characteristics are met and chronic
rome_iv_functional_dysphagia(1, 1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Major Motility Disorder Present)
# All criteria met except manometry shows achalasia (0)
rome_iv_functional_dysphagia(1, 1, 1, 1, 1, 0, 1, 1)
}
