\name{rome_iv_fecal_incontinence}
\alias{rome_iv_fecal_incontinence}
\title{
Rome IV Diagnostic Criteria for Fecal Incontinence
}
\description{
Evaluates the Rome IV criteria for the diagnosis of Fecal Incontinence. Diagnosis requires the recurrent uncontrolled passage of fecal material in an individual with a developmental age of at least 4 years, with symptom onset at least 6 months prior and active symptoms for the last 3 months, after excluding organic causes.
}
\usage{
rome_iv_fecal_incontinence(recurrent_uncontrolled_passage, developmental_age_ge_4,
                           symptom_onset_ge_6mo, active_symptoms_3mo,
                           organic_causes_excluded)
}
\arguments{
  \item{recurrent_uncontrolled_passage}{
Numeric (0 or 1). Is there recurrent uncontrolled passage of fecal material? (1 = Yes).
}
  \item{developmental_age_ge_4}{
Numeric (0 or 1). Is the individual's developmental age at least 4 years? (1 = Yes).
}
  \item{symptom_onset_ge_6mo}{
Numeric (0 or 1). Did symptoms begin at least 6 months ago? (1 = Yes).
}
  \item{active_symptoms_3mo}{
Numeric (0 or 1). Have criteria been fulfilled for the last 3 months? (1 = Yes).
}
  \item{organic_causes_excluded}{
Numeric (0 or 1). Have structural or other organic causes been excluded by appropriate medical evaluation? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Fecal Incontinence" or "Criteria Not Met".}
}
\references{
Rao SS, Bharucha AE, Chiarioni G, et al. Anorectal Disorders. Gastroenterology. 2016;150:1430-1442. doi:10.1053/j.gastro.2016.02.009
}
\examples{

# Example 1: Criteria Met
# Recurrent passage, Age 45, Duration met, Organic causes ruled out
rome_iv_fecal_incontinence(1, 1, 1, 1, 1)

# Example 2: Not Met (Duration too short)
# Recurrent passage, Age 45, Onset 1 month ago (0)
rome_iv_fecal_incontinence(1, 1, 0, 1, 1)
}
