\name{riete_hemorrhage_risk}
\alias{riete_hemorrhage_risk}
\title{
RIETE Score for Risk of Hemorrhage in Pulmonary Embolism Treatment
}
\description{
Calculates the RIETE Score to predict the risk of major hemorrhage within the first 3 months of anticoagulant treatment for Venous Thromboembolism (VTE). The score helps stratify patients into Low, Intermediate, and High risk categories based on six clinical variables.
}
\usage{
riete_hemorrhage_risk(age_gt_75, recent_bleeding, cancer, creatinine_gt_1_2,
                      hemoglobin_lt_13_or_12, pe_diagnosis)
}
\arguments{
  \item{age_gt_75}{
Numeric (0 or 1). Patient age > 75 years. (1 = Yes, +1 point).
}
  \item{recent_bleeding}{
Numeric (0 or 1). Recent major bleeding (within 30 days prior to VTE diagnosis). (1 = Yes, +2 points).
}
  \item{cancer}{
Numeric (0 or 1). Active cancer. (1 = Yes, +1 point).
}
  \item{creatinine_gt_1_2}{
Numeric (0 or 1). Abnormal creatinine levels (> 1.2 mg/dL). (1 = Yes, +1.5 points).
}
  \item{hemoglobin_lt_13_or_12}{
Numeric (0 or 1). Anemia (Hemoglobin < 13 g/dL for men, < 12 g/dL for women). (1 = Yes, +1.5 points).
}
  \item{pe_diagnosis}{
Numeric (0 or 1). Clinically overt Pulmonary Embolism (PE). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{RIETE_Score}{The calculated risk score (Range 0-8).}
\item{Risk_Category}{Classification (Low: 0, Intermediate: 1-4, High: >4).}
\item{Major_Bleeding_Risk_3_Months}{Estimated risk of major bleeding.}
\item{Fatal_Bleeding_Risk_3_Months}{Estimated risk of fatal bleeding.}
}
\references{
Nieto JA, Solano R, Trapero-Gimeno I, et al. Fatal bleeding in patients receiving anticoagulant therapy for venous thromboembolism: findings from the RIETE registry. J Thromb Haemost. 2010;8(6):1216-1222. doi:10.1111/j.1538-7836.2010.03852.x
}
\examples{

# Example 1: High Risk
# Recent Bleed (+2), Anemia (+1.5), Creatinine >1.2 (+1.5)
# Score = 5
riete_hemorrhage_risk(0, 1, 0, 1, 1, 0)

# Example 2: Low Risk
# 60yo, No risk factors
# Score = 0
riete_hemorrhage_risk(0, 0, 0, 0, 0, 0)
}
