\name{rcvs2_score}
\alias{rcvs2_score}
\title{
RCVS2 Score for Reversible Cerebral Vasoconstriction Syndrome
}
\description{
Calculates the RCVS2 score to distinguish Reversible Cerebral Vasoconstriction Syndrome (RCVS) from other intracranial arteriopathies (e.g., Primary Angiitis of the CNS) in adult patients (18-55 years) presenting with abnormal intracranial vascular imaging.
}
\usage{
rcvs2_score(recurrent_thunderclap_headache, carotid_artery_involvement,
            vasoconstrictive_trigger, sex, subarachnoid_hemorrhage)
}
\arguments{
  \item{recurrent_thunderclap_headache}{
Numeric (0 or 1). Presence of recurrent or single thunderclap headache. (1 = Yes, +5 points).
}
  \item{carotid_artery_involvement}{
Numeric (0 or 1). Is the intracranial carotid artery affected? (1 = Yes, -2 points).
}
  \item{vasoconstrictive_trigger}{
Numeric (0 or 1). Was a vasoconstrictive trigger identified (e.g., vasoactive medications, postpartum state, illicit drugs)? (1 = Yes, +3 points).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). (Female = +1 point, Male = 0 points).
}
  \item{subarachnoid_hemorrhage}{
Numeric (0 or 1). Is subarachnoid hemorrhage present on imaging? (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{RCVS2_Score}{The calculated total score (Range -2 to 10).}
\item{Risk_Category}{Classification of likelihood (Low <=2, Equivocal 3-4, High >=5).}
\item{Interpretation}{Diagnostic guidance based on the score.}
}
\references{
Rocha EA, Topcuoglu MA, Silva GS, Singhal AB. RCVS2 score and diagnostic approach for reversible cerebral vasoconstriction syndrome. Neurology. 2019;92(7):e639-e647. doi:10.1212/WNL.0000000000006917
}
\examples{

# Example 1: High Likelihood
# Recurrent TCH (+5), Female (+1), Trigger (+3), No Carotid (0), No SAH (0)
# Score = 9
rcvs2_score(1, 0, 1, "female", 0)

# Example 2: Low Likelihood
# No TCH (0), Carotid involved (-2), No Trigger (0), Male (0), No SAH (0)
# Score = -2
rcvs2_score(0, 1, 0, "male", 0)
}
