\name{promise_score_mpe}
\alias{promise_score_mpe}
\title{
PROMISE Score for Malignant Pleural Effusion
}
\description{
Calculates the PROMISE (PROgnostic score for Malignant Pleural Effusion) score to predict 3-month mortality and estimate median survival in patients with malignant pleural effusion (MPE). The score combines clinical and laboratory variables including hemoglobin, CRP, WBC, ECOG performance status, and cancer type.
}
\usage{
promise_score_mpe(hemoglobin_g_dl, crp_mg_l, wbc_count, ecog_score, cancer_type)
}
\arguments{
  \item{hemoglobin_g_dl}{
Numeric. Serum hemoglobin level in g/dL.
>= 12: 0 pts.
10 - <12: 1 pt.
< 10: 2 pts.
}
  \item{crp_mg_l}{
Numeric. Serum C-Reactive Protein level in mg/L.
< 50: 0 pts.
50 - <100: 1 pt.
>= 100: 2 pts.
}
  \item{wbc_count}{
Numeric. White Blood Cell count in x10^9/L.
< 12: 0 pts.
>= 12: 1 pt.
}
  \item{ecog_score}{
Numeric. ECOG Performance Status (0-4).
0-1: 0 pts.
2: 2 pts.
3-4: 4 pts.
}
  \item{cancer_type}{
String. Type of primary cancer.
"hematologic", "breast", "gynecologic": 0 pts.
"mesothelioma": 4 pts.
"lung", "gi", "gu", "sarcoma", "melanoma", "other": 2 pts.
}
}
\value{
A list containing:
\item{PROMISE_Score}{The calculated total score (Range 0-13).}
\item{Risk_Group}{Classification (Group A-D).}
\item{Est_3_Month_Survival}{Estimated 3-month survival probability.}
\item{Median_Survival}{Estimated median survival time in days.}
}
\references{
Psallidas I, Kanellakis NI, Gerry S, et al. Development and validation of the PROMISE score to predict survival in patients with malignant pleural effusion. Lancet Oncol. 2018;19(7):930-939. doi:10.1016/S1470-2045(18)30294-7
}
\examples{

# Example 1: Low Risk (Group A)
# Hb 13 (0), CRP 10 (0), WBC 6 (0), ECOG 0 (0), Breast CA (0)
# Score = 0
promise_score_mpe(13, 10, 6, 0, "breast")

# Example 2: High Risk (Group C)
# Hb 11 (1), CRP 80 (1), WBC 9 (0), ECOG 2 (2), Lung CA (2)
# Score = 6
promise_score_mpe(11, 80, 9, 2, "lung")
}
