\name{peld_cr_score}
\alias{peld_cr_score}
\title{
Pediatric End-Stage Liver Disease (PELD) Score (2023 Update)
}
\description{
Calculates the updated PELD score (often referred to as PELD-Cr) used by the OPTN for liver transplant prioritization in children under 12 years of age. This version, effective July 2023, incorporates serum creatinine into the calculation to better predict waitlist mortality.
}
\usage{
peld_cr_score(bilirubin, inr, albumin, creatinine, age_years, growth_failure,
              on_dialysis = 0, bilirubin_units = "mg/dL",
              albumin_units = "g/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{albumin}{
Numeric. Serum Albumin level.
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{age_years}{
Numeric. Patient age in years. (Points added if Age < 1 year).
}
  \item{growth_failure}{
Numeric (0 or 1). Presence of growth failure (defined as height or weight < -2 standard deviations below the mean for age and gender). (1 = Yes, + points).
}
  \item{on_dialysis}{
Numeric (0 or 1). History of dialysis (2 or more times in the last week) or 24 hours of CVVHD. (1 = Yes). If Yes, creatinine is set to 4.0 mg/dL.
}
  \item{bilirubin_units}{
String. Units for bilirubin. "mg/dL" (default) or "umol/L".
}
  \item{albumin_units}{
String. Units for albumin. "g/dL" (default) or "g/L".
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "umol/L".
}
}
\details{
The formula is:
\deqn{PELD = 10 \times (0.480 \times \ln(Bilirubin) + 1.857 \times \ln(INR) - 0.687 \times \ln(Albumin) + 0.961 \times \ln(Creatinine) + 0.436 \times (Age<1) + 0.667 \times (GrowthFailure))}
Adjustments:
- Bilirubin < 1 set to 1.
- INR < 1 set to 1.
- Creatinine < 0.1 set to 0.1.
- Creatinine > 4 set to 4.
}
\value{
A list containing:
\item{PELD_Cr_Score}{The calculated PELD score.}
}
\references{
OPTN Policy Notice. Update to PELD Score Calculation. 2023.
}
\examples{

# Example 1: Infant with growth failure and renal impairment
# Age 0.5, Bili 3.0, INR 1.5, Alb 2.5, Cr 0.8, Growth Failure Yes
peld_cr_score(3.0, 1.5, 2.5, 0.8, 0.5, 1)

# Example 2: Child, no growth failure, normal renal
# Age 5, Bili 1.0, INR 1.0, Alb 4.0, Cr 0.3, Growth Failure No
peld_cr_score(1.0, 1.0, 4.0, 0.3, 5, 0)
}
