\name{pediatric_asthma_severity_score}
\alias{pediatric_asthma_severity_score}
\title{
Pediatric Asthma Severity Score (PASS)
}
\description{
Calculates the Pediatric Asthma Severity Score (PASS), a clinical tool used to assess the severity of asthma exacerbations in children (ages 1-18). The score evaluates three physical exam findings: wheezing, work of breathing, and prolongation of expiration. Scores correlate with the decision to admit or discharge.
}
\usage{
pediatric_asthma_severity_score(wheezing, work_of_breathing, prolongation_of_expiration)
}
\arguments{
  \item{wheezing}{
String. Severity of wheezing.
"normal_mild": None or mild (0 pts).
"moderate": Moderate (1 pt).
"severe": Severe wheezing or absent breath sounds due to poor air movement (2 pts).
}
  \item{work_of_breathing}{
String. Use of accessory muscles and retractions.
"normal_mild": Normal or mildly increased (0 pts).
"moderate": Moderate (1 pt).
"severe": Severe (2 pts).
}
  \item{prolongation_of_expiration}{
String. Ratio of expiration to inspiration.
"normal_mild": Normal or mildly prolonged (0 pts).
"moderate": Moderately prolonged (1 pt).
"severe": Severely prolonged (2 pts).
}
}
\value{
A list containing:
\item{PASS_Score}{The calculated total score (Range 0-6).}
\item{Interpretation}{Clinical guidance based on the score (Score < 2 suggests discharge; >= 2 suggests need for further observation or admission).}
}
\references{
Gorelick MH, Scribano PV, Stevens MW, et al. Predicting admission in children with acute asthma. Pediatr Emerg Care. 2008;24(11):735-744. doi:10.1097/PEC.0b013e31818c26e2
}
\examples{

# Example 1: Mild Exacerbation
# Mild wheeze (0), Moderate work (1), Normal expiration (0)
# Score = 1
pediatric_asthma_severity_score("normal_mild", "moderate", "normal_mild")

# Example 2: Severe Exacerbation
# Severe wheeze (2), Severe work (2), Severe expiration (2)
# Score = 6
pediatric_asthma_severity_score("severe", "severe", "severe")
}
