\name{ovat_screening_tool}
\alias{ovat_screening_tool}
\title{
Ongoing Violence Assessment Tool (OVAT)
}
\description{
Calculates the OVAT score, a concise 4-item screening tool derived from the HITS index. It is designed specifically to identify ongoing (current) intimate partner violence in clinical settings. A "Yes" to any question constitutes a positive screen.
}
\usage{
ovat_screening_tool(physically_hurt, threaten_harm, scream_curse,
                    insult_talk_down)
}
\arguments{
  \item{physically_hurt}{
Numeric (0 or 1). Has your partner physically hurt you? (1 = Yes).
}
  \item{threaten_harm}{
Numeric (0 or 1). Has your partner threatened you with harm? (1 = Yes).
}
  \item{scream_curse}{
Numeric (0 or 1). Has your partner screamed or cursed at you? (1 = Yes).
}
  \item{insult_talk_down}{
Numeric (0 or 1). Has your partner insulted or talked down to you? (1 = Yes).
}
}
\value{
A list containing:
\item{OVAT_Score}{The calculated total score (Range 0-4).}
\item{Screening_Result}{"Positive Screen" (Score >= 1) or "Negative Screen".}
\item{Recommendation}{Clinical guidance based on the result.}
}
\references{
Ernst AA, Weiss SJ, Cham E, Hall LC, Nick TG. Ongoing Violence Assessment Tool (OVAT): development and validation of a new screening tool for identifying ongoing intimate partner violence. Acad Emerg Med. 2002;9(11):1383-1390.
}
\examples{

# Example 1: Positive Screen
# Partner screams/curses (1), no physical harm (0)
ovat_screening_tool(0, 0, 1, 0)

# Example 2: Negative Screen
# No affirmative answers
ovat_screening_tool(0, 0, 0, 0)
}
