\name{ottawa_sah_rule}
\alias{ottawa_sah_rule}
\title{
Ottawa Subarachnoid Hemorrhage (SAH) Rule
}
\description{
Calculates the Ottawa SAH Rule result for patients presenting with acute non-traumatic headache. This clinical decision rule has 100\% sensitivity for subarachnoid hemorrhage, allowing clinicians to rule out SAH without further investigation (CT/LP) if all criteria are absent.
}
\usage{
ottawa_sah_rule(age, neck_pain_stiffness, witnessed_loc, onset_exertion,
                thunderclap_headache, limited_neck_flexion)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 40 is a high-risk criterion).
}
  \item{neck_pain_stiffness}{
Numeric (0 or 1). Patient reports neck pain or stiffness? (1 = Yes).
}
  \item{witnessed_loc}{
Numeric (0 or 1). Was there witnessed loss of consciousness? (1 = Yes).
}
  \item{onset_exertion}{
Numeric (0 or 1). Did the headache start during exertion? (1 = Yes).
}
  \item{thunderclap_headache}{
Numeric (0 or 1). Was it a thunderclap headache (instantly peaking pain)? (1 = Yes).
}
  \item{limited_neck_flexion}{
Numeric (0 or 1). Is there limited neck flexion on physical examination? (1 = Yes).
}
}
\value{
A list containing:
\item{Result}{Recommendation regarding the need for investigation (Investigate vs. Rule Out).}
\item{Criteria_Met}{List of specific criteria that triggered a positive result.}
}
\references{
Perry JJ, Stiell IG, Sivilotti ML, et al. Clinical decision rules to rule out subarachnoid hemorrhage for acute headache. JAMA. 2013;310(12):1248-1255. doi:10.1001/jama.2013.278018
}
\examples{

# Example 1: Investigate (Age >= 40)
# 45yo, No other symptoms
ottawa_sah_rule(45, 0, 0, 0, 0, 0)

# Example 2: Rule Out
# 30yo, No high risk features
ottawa_sah_rule(30, 0, 0, 0, 0, 0)

# Example 3: Investigate (Thunderclap)
# 25yo, Thunderclap headache
ottawa_sah_rule(25, 0, 0, 0, 1, 0)
}
