\name{nvps_pain_score}
\alias{nvps_pain_score}
\title{
Nonverbal Pain Scale (NVPS) for Nonverbal Patients
}
\description{
Calculates the NVPS score to assess pain in patients who are unable to verbalize their pain (e.g., sedated, intubated, or cognitively impaired patients). The scale evaluates five categories: Face, Activity, Guarding, Physiology (Vital Signs), and Respiratory.
}
\usage{
nvps_pain_score(face, activity, guarding, physiology_vital_signs, respiratory)
}
\arguments{
  \item{face}{
Numeric (0-2).
0: No particular expression or smile.
1: Occasional grimace, tearing, frowning, wrinkled forehead.
2: Frequent grimace, tearing, frowning, wrinkled forehead.
}
  \item{activity}{
Numeric (0-2).
0: Lying quietly, normal position.
1: Seeking attention through movement or slow/cautious movement.
2: Restless, excessive activity and/or withdrawal reflexes.
}
  \item{guarding}{
Numeric (0-2).
0: Lying quietly, no positioning of hands over areas of body.
1: Splinting areas of the body, tense.
2: Rigid, stiff.
}
  \item{physiology_vital_signs}{
Numeric (0-2).
0: Baseline vital signs unchanged.
1: Change in SBP > 20 mmHg or HR > 20 bpm.
2: Change in SBP > 30 mmHg or HR > 25 bpm.
}
  \item{respiratory}{
Numeric (0-2).
0: Baseline RR/SpO2/compliance unchanged.
1: RR > 10 above baseline, 5\% decrease in SpO2, or mild ventilator dyssynchrony.
2: RR > 20 above baseline, 10\% decrease in SpO2, or severe ventilator dyssynchrony.
}
}
\value{
A list containing:
\item{NVPS_Score}{The calculated total score (Range 0-10).}
\item{Interpretation}{Clinical interpretation of pain severity (No/Mild, Moderate, Severe).}
}
\references{
Odhner, M., Wegman, D., Freeland, N., Steinmetz, A., & Ingersoll, G. L. (2003). Assessing pain control in nonverbal critically ill adults. Dimensions of Critical Care Nursing, 22(6), 260-267.
}
\examples{

# Example 1: Moderate Pain
# Grimacing(1), Restless(2), Rigid(2), Stable Vitals(0), Mild Dyssynchrony(1)
# Score = 6
nvps_pain_score(1, 2, 2, 0, 1)

# Example 2: No Pain
# All baseline/normal
# Score = 0
nvps_pain_score(0, 0, 0, 0, 0)
}
