\name{newsom_chest_pain_score}
\alias{newsom_chest_pain_score}
\title{
Newsom Score for Non-Traumatic Chest Pain (CXR Rule)
}
\description{
Calculates the Newsom Score to determine the necessity of a chest radiograph (CXR) in patients presenting to the emergency department with non-traumatic chest pain. The rule identifies patients at low risk for significant intrathoracic pathology (e.g., pneumonia, heart failure, pneumothorax, malignancy) who may be safely managed without a chest x-ray.
}
\usage{
newsom_chest_pain_score(age, history_chf, history_smoking, hemoptysis,
                        history_tuberculosis, history_thromboembolism,
                        alcohol_abuse, temp_c, oxygen_saturation,
                        respiratory_rate, diminished_breath_sounds, rales)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Age >= 60 adds 1 point).
}
  \item{history_chf}{
Numeric (0 or 1). History of Congestive Heart Failure. (1 = Yes).
}
  \item{history_smoking}{
Numeric (0 or 1). History of smoking. (1 = Yes).
}
  \item{hemoptysis}{
Numeric (0 or 1). Presence of hemoptysis. (1 = Yes).
}
  \item{history_tuberculosis}{
Numeric (0 or 1). History of tuberculosis. (1 = Yes).
}
  \item{history_thromboembolism}{
Numeric (0 or 1). History of thromboembolic disease (DVT/PE). (1 = Yes).
}
  \item{alcohol_abuse}{
Numeric (0 or 1). Prior or current alcohol abuse. (1 = Yes).
}
  \item{temp_c}{
Numeric. Body temperature in degrees Celsius. (>= 38.0 C adds 1 point).
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation percentage (SpO2). (< 90\% adds 1 point).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (> 24 bpm adds 1 point).
}
  \item{diminished_breath_sounds}{
Numeric (0 or 1). Diminished breath sounds on auscultation. (1 = Yes).
}
  \item{rales}{
Numeric (0 or 1). Presence of rales/crackles on auscultation. (1 = Yes).
}
}
\value{
A list containing:
\item{Newsom_Score}{The total count of positive criteria.}
\item{Risk_Category}{"Low Risk" if score is 0, otherwise "Not Low Risk".}
\item{Recommendation}{Clinical guidance regarding the need for a Chest X-ray.}
}
\references{
Newsom C, et al. A clinical prediction rule for ordering chest radiographs in patients with non-traumatic chest pain. (Study validated in emergency settings).
}
\examples{

# Example 1: Low Risk (No CXR needed)
# 45yo, No history, Normal vitals, Clear lungs
newsom_chest_pain_score(45, 0, 0, 0, 0, 0, 0, 37.0, 98, 16, 0, 0)

# Example 2: Not Low Risk (CXR indicated)
# 70yo (+1), Hx CHF (+1), Rales (+1)
newsom_chest_pain_score(70, 1, 0, 0, 0, 0, 0, 37.0, 95, 20, 0, 1)
}
