\name{mskcc_motzer_score}
\alias{mskcc_motzer_score}
\title{
MSKCC/Motzer Score for Metastatic Renal Cell Carcinoma
}
\description{
Calculates the MSKCC (Motzer) Score for predicting survival in patients with metastatic Renal Cell Carcinoma (RCC) treated with systemic therapy (historically cytokines, now relevant for tyrosine kinase inhibitors and immunotherapy benchmarking). The score stratifies patients into Favorable, Intermediate, or Poor risk groups based on 5 clinical risk factors.
}
\usage{
mskcc_motzer_score(time_to_systemic_tx_lt_1yr, karnofsky_performance_status_lt_80,
                   serum_calcium_gt_10_mg_dl, hemoglobin_lt_lln, ldh_gt_1_5_uln)
}
\arguments{
  \item{time_to_systemic_tx_lt_1yr}{
Numeric (0 or 1). Time from initial diagnosis to start of systemic therapy < 1 year. (1 = Yes).
}
  \item{karnofsky_performance_status_lt_80}{
Numeric (0 or 1). Karnofsky Performance Status < 80\%. (1 = Yes).
}
  \item{serum_calcium_gt_10_mg_dl}{
Numeric (0 or 1). Serum Calcium > 10 mg/dL (>2.5 mmol/L). (1 = Yes).
}
  \item{hemoglobin_lt_lln}{
Numeric (0 or 1). Hemoglobin less than the lower limit of normal. (1 = Yes).
}
  \item{ldh_gt_1_5_uln}{
Numeric (0 or 1). Lactate Dehydrogenase > 1.5 times the Upper Limit of Normal. (1 = Yes).
}
}
\value{
A list containing:
\item{MSKCC_Motzer_Score}{The calculated risk score (0-5).}
\item{Risk_Group}{Classification (Favorable: 0, Intermediate: 1-2, Poor: >=3).}
\item{Median_Overall_Survival}{Estimated median overall survival based on the original validation cohort.}
}
\references{
Motzer RJ, Bacik J, Murphy BA, Russo P, Mazumdar M. Interferon-alfa as a comparative treatment for clinical trials of new therapies against advanced renal-cell carcinoma. J Clin Oncol. 2002;20(1):289-296. doi:10.1200/JCO.2002.20.1.289
}
\examples{

# Example 1: Poor Risk
# <1yr to tx (1), Low KPS (1), High LDH (1)
# Score = 3
mskcc_motzer_score(1, 1, 0, 0, 1)

# Example 2: Favorable Risk
# No risk factors present
# Score = 0
mskcc_motzer_score(0, 0, 0, 0, 0)
}
