\name{mirels_fracture_score}
\alias{mirels_fracture_score}
\title{
Mirels' Criteria for Prophylactic Fixation
}
\description{
Calculates the Mirels' Score to assess the risk of pathological fracture in long bones due to metastatic disease. The score evaluates four parameters: site, pain, lesion type, and lesion size. It helps determine whether prophylactic surgical fixation or radiotherapy is the appropriate management strategy.
}
\usage{
mirels_fracture_score(site, pain, lesion_type, size_ratio)
}
\arguments{
  \item{site}{
String. Location of the lesion.
"upper_limb": Upper extremity (1 pt).
"lower_limb": Lower extremity (2 pts).
"peritrochanteric": Peritrochanteric region (3 pts).
}
  \item{pain}{
String. Severity of pain.
"mild": Mild pain (1 pt).
"moderate": Moderate pain (2 pts).
"functional": Functional/Severe pain (3 pts).
}
  \item{lesion_type}{
String. Radiographic appearance of the lesion.
"blastic": Blastic (1 pt).
"mixed": Mixed (2 pts).
"lytic": Lytic (3 pts).
}
  \item{size_ratio}{
String. Size of the lesion relative to the bone diameter.
"lt_one_third": < 1/3 of bone diameter (1 pt).
"one_third_to_two_thirds": 1/3 - 2/3 of bone diameter (2 pts).
"gt_two_thirds": > 2/3 of bone diameter (3 pts).
}
}
\value{
A list containing:
\item{Mirels_Score}{The calculated total score (Range 4-12).}
\item{Recommendation}{Clinical guidance based on the score threshold (Fixation indicated for score >= 9).}
\item{Est_Fracture_Risk}{Estimated risk of pathological fracture.}
}
\references{
Mirels H. Metastatic disease in long bones. A proposed scoring system for diagnosing impending pathologic fractures. Clin Orthop Relat Res. 1989;(249):256-264.
}
\examples{

# Example 1: High Risk
# Peritrochanteric (3), Functional pain (3), Lytic (3), >2/3 size (3)
# Score = 12
mirels_fracture_score("peritrochanteric", "functional", "lytic", "gt_two_thirds")

# Example 2: Low Risk
# Upper limb (1), Mild pain (1), Blastic (1), <1/3 size (1)
# Score = 4
mirels_fracture_score("upper_limb", "mild", "blastic", "lt_one_third")
}
