\name{mbig_score}
\alias{mbig_score}
\title{
Modified Brain Injury Guidelines (mBIG) for TBI
}
\description{
Classifies patients with Traumatic Brain Injury (TBI) and intracranial hemorrhage into three risk categories (mBIG 1, 2, or 3) to guide resource utilization, including the need for neurosurgical consultation, repeat imaging, and hospitalization. This modified version (Khan et al., 2020) updates the original BIG criteria for improved safety and reproducibility.
}
\usage{
mbig_score(gcs, focal_neuro_deficit, anti_coagulation, intoxication,
           skull_fracture_type, epidural_hematoma, subdural_hematoma_mm,
           intraparenchymal_hemorrhage_mm, subarachnoid_hemorrhage_type,
           intraventricular_hemorrhage)
}
\arguments{
  \item{gcs}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{focal_neuro_deficit}{
Numeric (0 or 1). Presence of focal neurological findings or pupillary asymmetry. (1 = Yes).
}
  \item{anti_coagulation}{
Numeric (0 or 1). Use of anticoagulants or antiplatelets (excluding aspirin 81mg in some protocols, but often any agents). (1 = Yes).
}
  \item{intoxication}{
Numeric (0 or 1). Alcohol or drug intoxication present (e.g., EtOH > 80 mg/dL). (1 = Yes).
}
  \item{skull_fracture_type}{
String. "none", "non_displaced", or "displaced".
}
  \item{epidural_hematoma}{
Numeric (0 or 1). Presence of Epidural Hematoma (EDH). (1 = Yes). Note: Any EDH places patient in mBIG 3.
}
  \item{subdural_hematoma_mm}{
Numeric. Size of Subdural Hematoma (SDH) in millimeters. (<4mm: mBIG 1, 4-7.9mm: mBIG 2, >=8mm: mBIG 3).
}
  \item{intraparenchymal_hemorrhage_mm}{
Numeric. Size of Intraparenchymal Hemorrhage (IPH) in millimeters. (<4mm: mBIG 1, 4-7.9mm: mBIG 2, >=8mm: mBIG 3).
}
  \item{subarachnoid_hemorrhage_type}{
String. Extent of Subarachnoid Hemorrhage (SAH).
"none": No SAH.
"trace": <= 3 sulci and < 1 mm.
"localized": 1 hemisphere or 1-3 mm.
"extensive": Bi-hemispheric or > 3 mm.
}
  \item{intraventricular_hemorrhage}{
Numeric (0 or 1). Presence of Intraventricular Hemorrhage (IVH). (1 = Yes).
}
}
\value{
A list containing:
\item{mBIG_Category}{The assigned risk category (mBIG 1, 2, or 3).}
\item{Management_Plan}{Recommendations for admission, imaging, and consultation.}
}
\references{
Khan AD, Elseth AJ, Brosius JA, et al. Multicenter assessment of the Brain Injury Guidelines and a proposal of guideline modifications. Trauma Surg Acute Care Open. 2020;5(1):e000483. doi:10.1136/tsaco-2020-000483
}
\examples{

# Example 1: Low Risk (mBIG 1)
# GCS 15, Small SDH (3mm), No other findings
mbig_score(15, 0, 0, 0, "none", 0, 3, 0, "none", 0)

# Example 2: Moderate Risk (mBIG 2)
# GCS 15, Non-displaced fracture, 5mm IPH
mbig_score(15, 0, 0, 0, "non_displaced", 0, 0, 5, "none", 0)

# Example 3: High Risk (mBIG 3)
# GCS 15, On Warfarin (Anti-coag)
mbig_score(15, 0, 1, 0, "none", 0, 0, 0, "none", 0)
}
