\name{macocha_score}
\alias{macocha_score}
\title{
MACOCHA Score for Difficult Intubation in ICU
}
\description{
Calculates the MACOCHA score to predict the risk of difficult endotracheal intubation specifically in critically ill patients in the Intensive Care Unit (ICU). A score of 3 or greater identifies patients at high risk for difficult intubation.
}
\usage{
macocha_score(mallampati_iii_iv, apnea_syndrome, cervical_spine_limited,
              mouth_opening_lt_3cm, coma_gcs_lt_8, hypoxia_severe,
              non_anesthesiologist)
}
\arguments{
  \item{mallampati_iii_iv}{
Numeric (0 or 1). Mallampati Score III or IV. (1 = Yes, +5 points).
}
  \item{apnea_syndrome}{
Numeric (0 or 1). Obstructive Sleep Apnea Syndrome (OSAS). (1 = Yes, +2 points).
}
  \item{cervical_spine_limited}{
Numeric (0 or 1). Reduced mobility of the cervical spine. (1 = Yes, +1 point).
}
  \item{mouth_opening_lt_3cm}{
Numeric (0 or 1). Limited mouth opening (< 3 cm). (1 = Yes, +1 point).
}
  \item{coma_gcs_lt_8}{
Numeric (0 or 1). Coma (Glasgow Coma Scale < 8). (1 = Yes, +1 point).
}
  \item{hypoxia_severe}{
Numeric (0 or 1). Severe hypoxia (SpO2 < 80\% despite preoxygenation). (1 = Yes, +1 point).
}
  \item{non_anesthesiologist}{
Numeric (0 or 1). Operator is a non-anesthesiologist. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{MACOCHA_Score}{The calculated score (Range 0-12).}
\item{Risk_Category}{"Low Risk" (Score 0-2) or "High Risk" (Score >= 3).}
\item{Recommendation}{Clinical guidance for airway management preparation.}
}
\references{
De Jong A, Molinari N, Terzi N, et al. Early identification of patients at risk of difficult intubation in the intensive care unit: development and validation of the MACOCHA score in a multicenter cohort study. Am J Respir Crit Care Med. 2013;187(8):832-839. doi:10.1164/rccm.201210-1851OC
}
\examples{

# Example 1: High Risk
# Mallampati III (+5), Coma (+1)
# Score = 6
macocha_score(1, 0, 0, 0, 1, 0, 0)

# Example 2: Low Risk
# OSAS (+2), No other factors
# Score = 2
macocha_score(0, 1, 0, 0, 0, 0, 0)
}
