\name{iwg2_alzheimers_criteria}
\alias{iwg2_alzheimers_criteria}
\title{
IWG-2 Criteria for Alzheimer's Disease Diagnosis
}
\description{
Applies the International Working Group 2 (IWG-2) criteria (2014) for the diagnosis of Alzheimer's Disease. These criteria define AD as a clinico-biological entity, requiring both a specific clinical phenotype (typical amnestic or atypical) and in vivo evidence of Alzheimer's pathology (pathophysiological biomarkers).
}
\usage{
iwg2_alzheimers_criteria(clinical_phenotype_present,
                         pathophysiological_marker_positive,
                         autosomal_dominant_mutation_present)
}
\arguments{
  \item{clinical_phenotype_present}{
Numeric (0 or 1). Presence of a specific clinical phenotype of AD (Typical Amnestic or Atypical: Posterior Cortical Atrophy, Logopenic Aphasia, Frontal Variant). (1 = Yes).
}
  \item{pathophysiological_marker_positive}{
Numeric (0 or 1). Presence of a positive pathophysiological biomarker (Low CSF Abeta42 + High Tau, or Positive Amyloid PET). (1 = Yes).
}
  \item{autosomal_dominant_mutation_present}{
Numeric (0 or 1). Presence of a proven autosomal dominant mutation (PSEN1, PSEN2, APP). (1 = Yes).
}
}
\value{
A list containing:
\item{IWG2_Diagnosis}{The diagnostic category determined by the criteria.}
\item{Classification}{General classification (Definite, Supported, At Risk, or Not Met).}
}
\references{
Dubois B, Feldman HH, Jacova C, et al. Advancing research diagnostic criteria for Alzheimer's disease: the IWG-2 criteria. Lancet Neurol. 2014;13(6):614-629. doi:10.1016/S1474-4422(14)70090-0
}
\examples{

# Example 1: Diagnosis Confirmed
# Phenotype present (1), Positive Biomarker (1), No mutation (0)
iwg2_alzheimers_criteria(1, 1, 0)

# Example 2: Preclinical (Asymptomatic at risk)
# No symptoms (0), Positive Biomarker (1), No mutation (0)
iwg2_alzheimers_criteria(0, 1, 0)
}
