\name{immunization_schedule_cdc}
\alias{immunization_schedule_cdc}
\title{
CDC Childhood Immunization Schedule
}
\description{
Generates a list of recommended vaccines based on the child's current age in months, following the standard CDC immunization schedule (birth through 18 years). This function assumes the child is on track with previous doses.
}
\usage{
immunization_schedule_cdc(current_age_months)
}
\arguments{
  \item{current_age_months}{
Numeric. The age of the patient in months.
}
}
\value{
A list containing:
\item{Age_Months}{Input age.}
\item{Recommended_Vaccines}{A vector of strings listing the vaccines typically administered at this specific age visit.}
}
\references{
Centers for Disease Control and Prevention (CDC). Recommended Child and Adolescent Immunization Schedule for ages 18 years or younger, United States, 2024.
}
\examples{

# Example 1: 2 Month Visit
immunization_schedule_cdc(2)

# Example 2: 1 Year Visit (12 months)
immunization_schedule_cdc(12)

# Example 3: 11 Year Visit (132 months)
immunization_schedule_cdc(132)
}
