\name{gipss_pmf_score}
\alias{gipss_pmf_score}
\title{
Genetically Inspired Prognostic Scoring System (GIPSS) for Primary Myelofibrosis
}
\description{
Calculates the GIPSS score to estimate overall survival in patients with Primary Myelofibrosis (PMF). Unlike other scoring systems (e.g., DIPSS), GIPSS relies exclusively on genetic markers (karyotype and mutations) and one clinical variable (platelet count).
}
\usage{
gipss_pmf_score(karyotype_category, platelet_count, asxl1_mutation,
                srsf2_mutation, u2af1_q157_mutation)
}
\arguments{
  \item{karyotype_category}{
String. Cytogenetic risk category.
"very_high_risk": Single/multiple abnormalities of -7, i(17q), inv(3)/3q21, 12p-/12p11.2, 11q-/11q23, or +21 (+2 points).
"unfavorable": Any other abnormal karyotype (+1 point).
"favorable": Normal karyotype or sole abnormalities of 13q-, 20q-, +9, chrm 1 translocation/duplication, or sex chromosome abnormality (0 points).
}
  \item{platelet_count}{
Numeric. Platelet count in 10^9/L. (< 100 x 10^9/L adds +1 point).
}
  \item{asxl1_mutation}{
Numeric (0 or 1). Presence of ASXL1 mutation. (1 = Yes, +1 point).
}
  \item{srsf2_mutation}{
Numeric (0 or 1). Presence of SRSF2 mutation. (1 = Yes, +1 point).
}
  \item{u2af1_q157_mutation}{
Numeric (0 or 1). Presence of U2AF1 Q157 mutation. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{GIPSS_Score}{The calculated score (Range 0-6).}
\item{Risk_Category}{Classification (Low, Int-1, Int-2, High).}
\item{Median_Overall_Survival}{Estimated median survival based on the Mayo Clinic validation cohort.}
}
\references{
Tefferi A, Guglielmelli P, Nicolosi M, et al. GIPSS: genetically inspired prognostic scoring system for primary myelofibrosis. Leukemia. 2018;32(7):1631-1642. doi:10.1038/s41375-018-0107-z
}
\examples{

# Example 1: High Risk
# VHR Karyotype (+2), Platelets 150 (0), ASXL1 (+1)
# Score = 3
gipss_pmf_score("very_high_risk", 150, 1, 0, 0)

# Example 2: Low Risk
# Favorable Karyotype, Platelets 250, No mutations
# Score = 0
gipss_pmf_score("favorable", 250, 0, 0, 0)
}
