\name{free_water_deficit}
\alias{free_water_deficit}
\title{
Free Water Deficit in Hypernatremia
}
\description{
Calculates the estimated free water deficit in patients with hypernatremia. The formula relies on Total Body Water (TBW), which is estimated based on the patient's age, sex, and weight. This calculation helps guide fluid replacement therapy to lower serum sodium levels safely.
}
\usage{
free_water_deficit(current_na, weight_kg, age, sex, target_na = 140)
}
\arguments{
  \item{current_na}{
Numeric. Current serum sodium level in mEq/L.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{age}{
Numeric. Patient age in years. Used to determine the TBW fraction (Children: 0.6; Adults 18-64: M=0.6/F=0.5; Elderly >=65: M=0.5/F=0.45).
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{target_na}{
Numeric. The desired target serum sodium level. Defaults to 140 mEq/L.
}
}
\value{
A list containing:
\item{Free_Water_Deficit_L}{The estimated volume of free water required to correct the sodium to the target level.}
\item{Total_Body_Water_L}{The estimated Total Body Water used in the calculation.}
\item{TBW_Fraction_Used}{The coefficient used to calculate TBW based on demographics.}
}
\references{
Adrogué HJ, Madias NE. Hypernatremia. N Engl J Med. 2000;342(20):1493-1499. doi:10.1056/NEJM200005183422006
}
\examples{

# Example 1: Adult Male
# Na 160, Wt 75kg, Age 40 (TBW factor 0.6)
# TBW = 45L. Deficit = 45 * ((160/140) - 1) = 6.4 L
free_water_deficit(160, 75, 40, "male")

# Example 2: Elderly Female
# Na 155, Wt 60kg, Age 75 (TBW factor 0.45)
# TBW = 27L. Deficit = 27 * ((155/140) - 1) = 2.9 L
free_water_deficit(155, 60, 75, "female")
}
