\name{drip_pneumonia_score}
\alias{drip_pneumonia_score}
\title{
Drug Resistance in Pneumonia (DRIP) Score
}
\description{
Calculates the DRIP Score to predict the risk of drug-resistant pathogens in patients with community-acquired pneumonia (CAP). This tool helps guide empiric antibiotic selection, potentially reducing the unnecessary use of broad-spectrum agents (like vancomycin or piperacillin-tazobactam) in low-risk patients.
}
\usage{
drip_pneumonia_score(antibiotic_use_60d, long_term_care, tube_feeding,
                     prior_drug_resistant_organism_1yr, hospitalization_60d,
                     chronic_pulmonary_disease, poor_functional_status,
                     acid_suppression_14d, wound_care, mrsa_colonization_1yr)
}
\arguments{
  \item{antibiotic_use_60d}{
Numeric (0 or 1). Antibiotic use within the past 60 days. (1 = Yes, +2 points).
}
  \item{long_term_care}{
Numeric (0 or 1). Resident of a long-term care facility (nursing home, skilled nursing, rehab; excludes assisted living/group homes). (1 = Yes, +2 points).
}
  \item{tube_feeding}{
Numeric (0 or 1). Presence of tube feeding (NG, NJ, or PEG). (1 = Yes, +2 points).
}
  \item{prior_drug_resistant_organism_1yr}{
Numeric (0 or 1). Prior culture-proven drug-resistant pneumonia within the past year. (1 = Yes, +2 points).
}
  \item{hospitalization_60d}{
Numeric (0 or 1). Hospitalization within the past 60 days. (1 = Yes, +1 point).
}
  \item{chronic_pulmonary_disease}{
Numeric (0 or 1). History of chronic pulmonary disease (COPD, Asthma, ILD, etc.). (1 = Yes, +1 point).
}
  \item{poor_functional_status}{
Numeric (0 or 1). Poor functional status (Karnofsky < 70 or non-ambulatory). (1 = Yes, +1 point).
}
  \item{acid_suppression_14d}{
Numeric (0 or 1). Use of gastric acid suppression (PPI or H2 blocker) within the past 14 days. (1 = Yes, +1 point).
}
  \item{wound_care}{
Numeric (0 or 1). Active wound care at the time of admission. (1 = Yes, +1 point).
}
  \item{mrsa_colonization_1yr}{
Numeric (0 or 1). Documented MRSA colonization within the past year. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{DRIP_Score}{The calculated total score (Range 0-14).}
\item{Risk_Level}{"Low Risk" (<4) or "High Risk" (>=4).}
\item{Recommendation}{Antibiotic stewardship guidance.}
}
\references{
Webb BJ, Dascomb K, Stenehjem E, et al. Derivation and Multicenter Validation of the Drug Resistance in Pneumonia Clinical Prediction Score. Antimicrob Agents Chemother. 2016;60(5):2652-2663. doi:10.1128/AAC.03071-15
}
\examples{

# Example 1: High Risk
# Recent Abx (+2), LTC (+2), Chronic lung disease (+1)
# Score = 5
drip_pneumonia_score(1, 1, 0, 0, 0, 1, 0, 0, 0, 0)

# Example 2: Low Risk
# Hospitalization (+1), PPI use (+1)
# Score = 2
drip_pneumonia_score(0, 0, 0, 0, 1, 0, 0, 1, 0, 0)
}
