\name{cns_ipi_score}
\alias{cns_ipi_score}
\title{
CNS-IPI (Central Nervous System International Prognostic Index)
}
\description{
Calculates the CNS-IPI score to predict the risk of CNS relapse in patients with Diffuse Large B-Cell Lymphoma (DLBCL) treated with R-CHOP. The score uses the five standard IPI factors plus specific involvement of the kidneys or adrenal glands.
}
\usage{
cns_ipi_score(age, ldh_elevated, ecog_gt_1, stage_iii_iv,
              extranodal_gt_1, kidney_adrenal_involvement)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 60 years adds +1 point).
}
  \item{ldh_elevated}{
Numeric (0 or 1). Serum LDH level > Normal. (1 = Yes, +1 point).
}
  \item{ecog_gt_1}{
Numeric (0 or 1). ECOG Performance Status > 1. (1 = Yes, +1 point).
}
  \item{stage_iii_iv}{
Numeric (0 or 1). Ann Arbor Stage III or IV. (1 = Yes, +1 point).
}
  \item{extranodal_gt_1}{
Numeric (0 or 1). Involvement of > 1 extranodal site. (1 = Yes, +1 point).
}
  \item{kidney_adrenal_involvement}{
Numeric (0 or 1). Involvement of kidney and/or adrenal glands. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{CNS_IPI_Score}{The calculated score (Range 0-6).}
\item{Risk_Group}{Classification (Low 0-1, Intermediate 2-3, High 4-6).}
\item{Est_2yr_CNS_Relapse_Risk}{Estimated 2-year risk of CNS relapse.}
}
\references{
Schmitz N, Zeynalova S, Nickelsen M, et al. CNS International Prognostic Index: A Risk Model for CNS Relapse in Patients With Diffuse Large B-Cell Lymphoma Treated With R-CHOP. J Clin Oncol. 2016;34(26):3150-3156. doi:10.1200/JCO.2015.65.6520
}
\examples{

# Example 1: High Risk
# 65yo (+1), LDH High (+1), Stage IV (+1), >1 Extranodal (+1), Kidney Inv (+1)
# Score = 5
cns_ipi_score(65, 1, 0, 1, 1, 1)

# Example 2: Low Risk
# 50yo, Normal LDH, Stage II, No extranodal, No kidney/adrenal
# Score = 0
cns_ipi_score(50, 0, 0, 0, 0, 0)
}
