\name{ckd_prediction_hiv}
\alias{ckd_prediction_hiv}
\title{
CKD Prediction in HIV Patients (D:A:D Score)
}
\description{
Calculates the D:A:D (Data Collection on Adverse Events of Anti-HIV Drugs) Risk Score for Chronic Kidney Disease. This tool estimates the 5-year risk of developing CKD (defined as confirmed eGFR < 60 mL/min/1.73 m^2) in HIV-positive patients with a baseline eGFR > 60.
}
\usage{
ckd_prediction_hiv(age, sex, iv_drug_user, baseline_egfr, current_cd4,
                   nadir_cd4, viral_load, hepatitis_c, history_cvd,
                   hypertension, diabetes)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. "Male" or "Female". (Male adds +1 point).
}
  \item{iv_drug_user}{
Numeric (0 or 1). History of Injection Drug Use. (1 = Yes, +3 points).
}
  \item{baseline_egfr}{
Numeric. Baseline eGFR in mL/min/1.73 m^2. Must be >= 60. (Lower eGFR values add more points).
}
  \item{current_cd4}{
Numeric. Current CD4 count in cells/mm^3. (<50: +3 pts; 50-199: +2 pts).
}
  \item{nadir_cd4}{
Numeric. Nadir (lowest historical) CD4 count in cells/mm^3. (<50: +2 pts; 50-199: +1 pt).
}
  \item{viral_load}{
Numeric. HIV RNA Viral Load in copies/mL. (>100,000 copies/mL adds +2 points).
}
  \item{hepatitis_c}{
Numeric (0 or 1). Hepatitis C Coinfection (Positive antibody or RNA). (1 = Yes, +1 point).
}
  \item{history_cvd}{
Numeric (0 or 1). History of Cardiovascular Disease. (1 = Yes, +2 points).
}
  \item{hypertension}{
Numeric (0 or 1). History of Hypertension. (1 = Yes, +2 points).
}
  \item{diabetes}{
Numeric (0 or 1). History of Diabetes Mellitus. (1 = Yes, +4 points).
}
}
\value{
A list containing:
\item{DAD_CKD_Score}{The calculated risk score.}
\item{Risk_Category}{Risk stratification (Low < 10, Medium 10-19, High >= 20).}
\item{Five_Year_Risk_Ratio}{Estimated 5-year probability of developing CKD expressed as a ratio (e.g., 1:32).}
}
\references{
Mocroft A, Kirk O, Reiss P, et al. Estimated glomerular filtration rate, chronic kidney disease and antiretroviral drug use in HIV-positive patients. AIDS. 2010;24(11):1667-1678. doi:10.1097/QAD.0b013e328339fe53
}
\examples{

# Example 1: High Risk
# 60yo Male (+12), eGFR 65 (+15), DM (+4)
# Score = 11 + 1 + 15 + 4 = 31
ckd_prediction_hiv(60, "male", 0, 65, 500, 200, 50, 0, 0, 0, 1)

# Example 2: Low Risk
# 30yo Female, eGFR 100, No comorbidities
# Score = 0
ckd_prediction_hiv(30, "female", 0, 100, 500, 300, 0, 0, 0, 0, 0)
}
