\name{chads_65_score}
\alias{chads_65_score}
\title{
CHADS-65 Score (Canadian Cardiovascular Society)
}
\description{
Calculates the CHADS-65 score for atrial fibrillation stroke risk stratification, based on the Canadian Cardiovascular Society (CCS) guidelines. This score modifies the standard CHADS2 score by lowering the age threshold to 65. It is used to guide the decision for Oral Anticoagulant (OAC) therapy.
}
\usage{
chads_65_score(age, chf, hypertension, diabetes, stroke_tia)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (>= 65 years adds +1 point).
}
  \item{chf}{
Numeric (0 or 1). Congestive Heart Failure. (1 = Yes, +1 point).
}
  \item{hypertension}{
Numeric (0 or 1). History of Hypertension. (1 = Yes, +1 point).
}
  \item{diabetes}{
Numeric (0 or 1). Diabetes Mellitus. (1 = Yes, +1 point).
}
  \item{stroke_tia}{
Numeric (0 or 1). History of Stroke or TIA. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{CHADS_65_Score}{The calculated score (Range 0-6).}
\item{Recommendation}{Clinical guidance regarding antithrombotic therapy.}
}
\references{
Andrade JG, et al. 2018 Focused Update of the Canadian Cardiovascular Society Guidelines for the Management of Atrial Fibrillation. Can J Cardiol. 2018;34(11):1371-1392. doi:10.1016/j.cjca.2018.08.026
}
\examples{

# Example 1: High Risk
# 66yo (+1), No other factors
# Score = 1 -> OAC Recommended
chads_65_score(66, 0, 0, 0, 0)

# Example 2: Low Risk
# 50yo, No risk factors
# Score = 0 -> No therapy
chads_65_score(50, 0, 0, 0, 0)
}
