\name{calculate_meld_score}
\alias{calculate_meld_score}
\title{
Model for End-Stage Liver Disease (MELD) / MELD-Na
}
\description{
Calculates the MELD-Na score, used to prioritize candidates for liver transplantation and predict 3-month mortality in patients with end-stage liver disease. This function implements the 2016 OPTN/UNOS update which incorporates serum sodium for patients with an initial MELD > 11.
}
\usage{
calculate_meld_score(bilirubin, inr, creatinine, sodium, on_dialysis = 0,
                     bilirubin_units = "mg/dL", creatinine_units = "mg/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine}{
Numeric. Serum creatinine level.
}
  \item{sodium}{
Numeric. Serum sodium level (mEq/L).
}
  \item{on_dialysis}{
Numeric (0 or 1). Has the patient had dialysis at least twice in the past week? (1 = Yes).
}
  \item{bilirubin_units}{
String. "mg/dL" (default) or "umol/L".
}
  \item{creatinine_units}{
String. "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{MELD_Na_Score}{The calculated MELD-Na score (capped at 40).}
\item{Est_3_Month_Mortality}{Estimated 3-month mortality based on the score range.}
}
\references{
Kamath PS, Wiesner RH, Malinchoc M, et al. A model to predict survival in patients with end-stage liver disease. Hepatology. 2001;33(2):464-470.
Kim WR, Biggins SW, Kremers WK, et al. Hyponatremia and mortality among patients on the liver-transplant waiting list. N Engl J Med. 2008;359(10):1018-1026.
}
\examples{

# Example 1: MELD-Na Adjustment Applied
# Bili 2.0, INR 1.5, Cr 1.5, Na 125 (Low Na increases score)
calculate_meld_score(2.0, 1.5, 1.5, 125, 0)

# Example 2: Standard MELD (Score <= 11)
# Bili 1.0, INR 1.0, Cr 1.0, Na 135
# Score = 6
calculate_meld_score(1.0, 1.0, 1.0, 135, 0)
}
