\name{burch_wartofsky_score}
\alias{burch_wartofsky_score}
\title{
Burch-Wartofsky Point Scale (BWPS) for Thyrotoxicosis
}
\description{
Calculates the Burch-Wartofsky Point Scale score to estimate the likelihood of Thyroid Storm in patients presenting with thyrotoxicosis. The scale aggregates scores from thermoregulatory dysfunction, central nervous system effects, gastrointestinal-hepatic dysfunction, cardiovascular tachycardia, heart failure, atrial fibrillation, and the presence of a precipitating history.
}
\usage{
burch_wartofsky_score(temp_c, cns_scale, gi_scale, heart_rate, chf_scale,
                      afib_present, precipitating_event)
}
\arguments{
  \item{temp_c}{
Numeric. Body temperature in degrees Celsius.
37.2-37.7: +5 pts.
37.8-38.2: +10 pts.
38.3-38.8: +15 pts.
38.9-39.3: +20 pts.
39.4-39.9: +25 pts.
>= 40.0: +30 pts.
}
  \item{cns_scale}{
Numeric (0-3). Central Nervous System effects.
0: Absent.
1: Mild (Agitation). +10 pts.
2: Moderate (Delirium, psychosis, extreme lethargy). +20 pts.
3: Severe (Seizures, coma). +30 pts.
}
  \item{gi_scale}{
Numeric (0-2). Gastrointestinal-Hepatic dysfunction.
0: Absent.
1: Moderate (Diarrhea, nausea/vomiting, abdominal pain). +10 pts.
2: Severe (Unexplained jaundice). +20 pts.
}
  \item{heart_rate}{
Numeric. Heart rate in bpm.
99-109: +5 pts.
110-119: +10 pts.
120-129: +15 pts.
130-139: +20 pts.
>= 140: +25 pts.
}
  \item{chf_scale}{
Numeric (0-3). Congestive Heart Failure severity.
0: Absent.
1: Mild (Pedal edema). +5 pts.
2: Moderate (Bibasilar rales). +10 pts.
3: Severe (Pulmonary edema). +15 pts.
}
  \item{afib_present}{
Numeric (0 or 1). Atrial Fibrillation present. (1 = Yes, +10 pts).
}
  \item{precipitating_event}{
Numeric (0 or 1). History of precipitating event (e.g., infection, surgery, trauma). (1 = Yes, +10 pts).
}
}
\value{
A list containing:
\item{BWPS_Score}{The calculated total score.}
\item{Interpretation}{Diagnostic likelihood (Unlikely < 25, Impending 25-44, Highly Suggestive >= 45).}
}
\references{
Burch HB, Wartofsky L. Life-threatening thyrotoxicosis. Thyroid storm. Endocrinol Metab Clin North Am. 1993;22(2):263-277.
}
\examples{

# Example 1: Highly Suggestive of Storm
# Temp 39.5 (+25), Mod CNS (+20), HR 145 (+25), No GI, No CHF, No Afib, Event (+10)
# Score = 80
burch_wartofsky_score(39.5, 2, 0, 145, 0, 0, 1)

# Example 2: Impending Storm
# Temp 38.0 (+10), Mild CNS (+10), HR 115 (+10), No other signs
# Score = 30
burch_wartofsky_score(38.0, 1, 0, 115, 0, 0, 0)
}
