\name{breast_cancer_brain_metastasis_gpa}
\alias{breast_cancer_brain_metastasis_gpa}
\title{
Breast-GPA for Brain Metastasis Survival
}
\description{
Calculates the Diagnosis-Specific Graded Prognostic Assessment (Breast-GPA) score. This tool estimates the median survival of patients with breast cancer who have developed brain metastases. The score is based on tumor subtype (ER/PR/HER2), Karnofsky Performance Status (KPS), age, and the presence of extracranial metastases.
}
\usage{
breast_cancer_brain_metastasis_gpa(subtype_er_pr_status, subtype_her2_status,
                                   kps, age, extracranial_metastases,
                                   number_of_brain_metastases)
}
\arguments{
  \item{subtype_er_pr_status}{
String. Estrogen/Progesterone Receptor status. "positive" or "negative".
}
  \item{subtype_her2_status}{
String. HER2 Receptor status. "positive" or "negative".
}
  \item{kps}{
Numeric. Karnofsky Performance Status (0-100).
<70: 0 pts.
70-80: 0.5 pts.
90-100: 1.0 pts.
}
  \item{age}{
Numeric. Patient age in years.
>=60: 0 pts.
<60: 0.5 pts.
}
  \item{extracranial_metastases}{
Numeric (0 or 1). Presence of extracranial metastases. (1 = Present [0 pts], 0 = Absent [0.5 pts]).
}
  \item{number_of_brain_metastases}{
Numeric. Number of brain metastases. (>1: 0 pts, 1: 0.5 pts).
}
}
\value{
A list containing:
\item{Breast_GPA_Score}{The calculated total score (Range 0.0 - 4.0).}
\item{Estimated_Median_Survival}{Estimated median survival time in months.}
}
\references{
Sperduto PW, Kased N, Roberge D, et al. Summary report on the graded prognostic assessment: an accurate and facile diagnosis-specific tool to estimate survival for patients with brain metastases. J Clin Oncol. 2012;30(4):419-425. doi:10.1200/JCO.2011.36.6972
}
\examples{

# Example 1: Poor Prognosis (Basal Type)
# Triple Negative (0), KPS 60 (0), Age 65 (0), ECM Present (0), Multiple Mets (0)
# Score = 0
breast_cancer_brain_metastasis_gpa("negative", "negative", 60, 65, 1, 3)

# Example 2: Good Prognosis (Luminal B)
# ER+ HER2+ (2.0), KPS 90 (1.0), Age 50 (0.5), No ECM (0.5), Single Met (0.5)
# Score = 4.0
breast_cancer_brain_metastasis_gpa("positive", "positive", 90, 50, 0, 1)
}
