\name{apgar_score}
\alias{apgar_score}
\title{
APGAR Score for Newborns
}
\description{
Calculates the APGAR score, a rapid method for assessing the clinical status of a newborn at 1 and 5 minutes after birth. The score evaluates five criteria: Appearance, Pulse, Grimace, Activity, and Respiration.
}
\usage{
apgar_score(appearance, pulse, grimace, activity, respiration)
}
\arguments{
  \item{appearance}{
Numeric (0-2). Skin Color.
0: Blue or pale all over.
1: Acrocyanosis (body pink, extremities blue).
2: Completely pink.
}
  \item{pulse}{
Numeric (0-2). Heart Rate.
0: Absent.
1: < 100 bpm.
2: > 100 bpm.
}
  \item{grimace}{
Numeric (0-2). Reflex Irritability (response to stimulation).
0: No response.
1: Grimace.
2: Cry or active withdrawal.
}
  \item{activity}{
Numeric (0-2). Muscle Tone.
0: Limp/Flaccid.
1: Some flexion.
2: Active motion.
}
  \item{respiration}{
Numeric (0-2). Respiratory Effort.
0: Absent.
1: Slow, irregular, or weak cry.
2: Good, vigorous cry.
}
}
\value{
A list containing:
\item{Total_Score}{The sum of the five components (Range 0-10).}
\item{Interpretation}{General assessment (Reassuring, Moderately Abnormal, or Low).}
}
\references{
Apgar V. A proposal for a new method of evaluation of the newborn infant. Curr Res Anesth Analg. 1953;32(4):260-267.
}
\examples{

# Example 1: Healthy Newborn
# Pink body/blue limbs (1), HR >100 (2), Cry (2), Active (2), Good cry (2)
# Score = 9
apgar_score(1, 2, 2, 2, 2)

# Example 2: Distressed Newborn
# Blue (0), HR <100 (1), Grimace (1), Flaccid (0), Irregular resp (1)
# Score = 3
apgar_score(0, 1, 1, 0, 1)
}
