\name{a_a_gradient}
\alias{a_a_gradient}
\title{
Alveolar-arterial (A-a) Oxygen Gradient
}
\description{
Calculates the A-a O2 Gradient, a measure of the difference between the alveolar concentration of oxygen (PAO2) and the arterial concentration of oxygen (PaO2). This gradient helps differentiate between extrapulmonary causes of hypoxemia (e.g., hypoventilation, high altitude) and intrapulmonary causes (e.g., V/Q mismatch, shunt, diffusion defects).

The function utilizes the Alveolar Gas Equation:
PAO2 = (FiO2 * (Patm - PH2O)) - (PaCO2 / R)
Where PH2O is assumed to be 47 mmHg and R (Respiratory Quotient) is assumed to be 0.8.
}
\usage{
a_a_gradient(pao2, paco2, fio2, age = NULL, patm = 760, elevation_m = NULL)
}
\arguments{
  \item{pao2}{
Numeric. Measured arterial partial pressure of oxygen (mmHg).
}
  \item{paco2}{
Numeric. Measured arterial partial pressure of carbon dioxide (mmHg).
}
  \item{fio2}{
Numeric. Fraction of Inspired Oxygen. Can be entered as a percentage (e.g., 21) or a decimal (e.g., 0.21).
}
  \item{age}{
Numeric (Optional). Patient age in years. Used to calculate the expected A-a gradient using the formula: (Age / 4) + 4.
}
  \item{patm}{
Numeric. Atmospheric pressure in mmHg. Defaults to 760 mmHg (Sea Level).
}
  \item{elevation_m}{
Numeric (Optional). Elevation in meters. If provided, this will override the 'patm' argument and estimate atmospheric pressure using the barometric formula.
}
}
\value{
A list containing:
\item{A_a_Gradient_mmHg}{The calculated difference between alveolar and arterial oxygen.}
\item{PAO2_Alveolar_Oxygen_mmHg}{The estimated partial pressure of oxygen in the alveoli.}
\item{Expected_Gradient_mmHg}{The predicted normal gradient for the patient's age (if age is provided).}
\item{Interpretation}{Clinical interpretation suggesting whether the gradient is normal (suggesting hypoventilation/low FiO2) or elevated (suggesting intrinsic lung pathology).}
}
\references{
Mellemgaard K. The alveolar-arterial oxygen difference: its size and components in normal man. Acta Physiol Scand. 1966;67(1):10-20. doi:10.1111/j.1748-1716.1966.tb03281.x

Kanber GJ, King FW, Eshchar YR, et al. The alveolar-arterial oxygen gradient in young and elderly men during air and oxygen breathing. Am Rev Respir Dis. 1968;97(3):376-381.
}
\examples{

# Example 1: Normal Gradient (Hypoventilation)
# 30yo on Room Air (21\%), PaO2 60, PaCO2 80
a_a_gradient(pao2 = 60, paco2 = 80, fio2 = 21, age = 30)

# Example 2: Elevated Gradient (V/Q Mismatch/Shunt)
# 60yo on 40\% FiO2, PaO2 80, PaCO2 40
a_a_gradient(pao2 = 80, paco2 = 40, fio2 = 0.40, age = 60)

# Example 3: High Altitude
# 25yo at 3000m elevation
a_a_gradient(pao2 = 50, paco2 = 30, fio2 = 21, age = 25, elevation_m = 3000)
}
