% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proofreadText.R
\name{proofreadText}
\alias{proofreadText}
\title{proofreadText}
\usage{
proofreadText(Model = "gpt-4o-mini", SelectedCode = TRUE, verbose = TRUE)
}
\arguments{
\item{Model}{The Large Language Model to be used for proofreading. Default is "gpt-4o-mini".}

\item{SelectedCode}{Logical flag to indicate whether to use the selected text in RStudio editor. Default is TRUE.}

\item{verbose}{Logical flag to print the progress. Default is TRUE.}
}
\value{
NULL if `SelectedCode` is TRUE, otherwise returns the proofread text to the clipboard.
}
\description{
Proofreads text during the development of an R package.
}
\details{
Proofread Text During R Package Development Through the RStudio API

This function offers a feature for proofreading text while developing an R package.
It can either use the text selected in the RStudio editor or read from the clipboard, perform the proofreading, and then either replace the selected text or return the result to the user's clipboard.
The language of the output will match the language of the input text. Using GPT-4 for execution is recommended.
}
\examples{
\dontrun{
# Proofread text from clipboard
proofreadText(SelectedCode = FALSE)
}
}
\author{
Satoshi Kume
}
