% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geminiGrounding4R.R
\name{geminiGrounding4R}
\alias{geminiGrounding4R}
\title{Gemini API Google Search Grounding Request (v1/v1beta, 2025-07)}
\usage{
geminiGrounding4R(
  mode,
  contents,
  model = "gemini-2.5-flash",
  api_version = "v1beta",
  store_history = FALSE,
  dynamic_threshold = 0.7,
  api_key = Sys.getenv("GoogleGemini_API_KEY"),
  max_tokens = 2048,
  debug = FALSE,
  enable_grounding = TRUE,
  ...
)
}
\arguments{
\item{mode}{One of `"text"`, `"stream_text"`, `"chat"`, `"stream_chat"`.}

\item{contents}{Character vector (single-turn) or list of message objects
(chat modes). See Examples.}

\item{model}{Gemini model ID. Default `"gemini-2.5-flash"`.}

\item{api_version}{API version for the Generative Language API (`"v1"` or `"v1beta"`). Default `"v1beta"`.}

\item{store_history}{Logical. If TRUE, chat history is persisted to the
`chat_history` env-var (JSON).}

\item{dynamic_threshold}{Numeric [0,1] for dynamic retrieval threshold (default: 0.7). Only used for Gemini 1.5 models with `googleSearchRetrieval`; ignored for newer models that use `google_search`.}

\item{api_key}{Your Google Gemini API key (default: `Sys.getenv("GoogleGemini_API_KEY")`).}

\item{max_tokens}{Maximum output tokens. Default 2048.}

\item{debug}{Logical. If TRUE, prints request details for debugging.}

\item{enable_grounding}{Logical. If TRUE, enables Google Search grounding (default).}

\item{...}{Additional `httr::POST` options (timeouts etc.).}
}
\value{
For non-stream modes, a parsed list. For stream modes, a list with
        `full_text` and `chunks`.
}
\description{
A thin R wrapper for Google Gemini API with Google Search grounding enabled.
Grounding improves factuality by incorporating web search results.
}
\examples{
\dontrun{
  # Synchronous text generation with grounding:
  result <- geminiGrounding4R(
    mode = "text",
    contents = "What is the current Google stock price?",
    store_history = FALSE,
    debug = TRUE,  # Enable debug to see request details
    api_key = Sys.getenv("GoogleGemini_API_KEY")
  )
  print(result)

  # Basic text generation without grounding (for troubleshooting):
  basic_result <- geminiGrounding4R(
    mode = "text",
    contents = "Hello, how are you?",
    enable_grounding = FALSE,
    debug = TRUE,
    api_key = Sys.getenv("GoogleGemini_API_KEY")
  )
  print(basic_result)

  # Chat mode with history storage:
  chat_history <- list(
    list(role = "user", text = "Hello"),
    list(role = "model", text = "Hi there! How can I help you?")
  )
  chat_result <- geminiGrounding4R(
    mode = "chat",
    contents = chat_history,
    store_history = TRUE,
    dynamic_threshold = 0.7,
    api_key = Sys.getenv("GoogleGemini_API_KEY")
  )
  print(chat_result)

  # Streaming text generation:
  stream_result <- geminiGrounding4R(
    mode = "stream_text",
    contents = "Tell me a story about a magic backpack.",
    store_history = FALSE,
    dynamic_threshold = 0.7,
    api_key = Sys.getenv("GoogleGemini_API_KEY")
  )
  print(stream_result$full_text)
}
}
\author{
Satoshi Kume (revised 2025-07-01)
}
