% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pr_auc.r
\name{generate_pr_auc_replica}
\alias{generate_pr_auc_replica}
\title{Compute bootstrap replica of pr auc}
\usage{
generate_pr_auc_replica(
  intermed_res_all_thrsld,
  seed,
  n_bt,
  propensity_scored,
  replace_zero_division_with = options::opt("replace_zero_division_with"),
  progress = options::opt("progress")
)
}
\arguments{
\item{intermed_res_all_thrsld}{Intermediate results as produced by
\code{compute_intermediate_results}, with a column \code{"searchspace_id"}
as grouping variable.}

\item{seed}{Pass a seed to make bootstrap replication reproducible.}

\item{n_bt}{An integer number of resamples to be used for bootstrapping.}

\item{propensity_scored}{Logical, whether to use propensity scores as
weights.}

\item{replace_zero_division_with}{In macro averaged results (doc-avg, subj-avg), it may occur that some
instances have no predictions or no gold standard. In these cases,
calculating precision and recall may lead to division by zero. CASIMiR
standardly removes these missing values from macro averages, leading to a
smaller support (count of instances that were averaged). Other
implementations of macro averaged precision and recall default to 0 in these
cases. This option allows to control the default. Set any value between 0
and 1. (Defaults to \code{NULL}, overwritable using option 'casimir.replace_zero_division_with' or environment variable 'R_CASIMIR_REPLACE_ZERO_DIVISION_WITH')}

\item{progress}{Display progress bars for iterated computations (like bootstrap CI or
pr curves). (Defaults to \code{FALSE}, overwritable using option 'casimir.progress' or environment variable 'R_CASIMIR_PROGRESS')}
}
\value{
A data.frame with columns \code{"boot_replicate", "pr_auc"}.
}
\description{
Helper function which performs the major bootstrap operation and wraps the
repeated application of \code{summarise_intermediate_results} and
\code{compute_pr_auc_from_curve} for each bootstrap run.
}
