% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram_ncont.R
\name{cartogram_ncont}
\alias{cartogram_ncont}
\alias{cartogram_ncont.SpatialPolygonsDataFrame}
\alias{cartogram_ncont.sf}
\title{Calculate Non-Contiguous Cartogram Boundaries}
\usage{
cartogram_ncont(x, weight, k = 1, inplace = TRUE)

\method{cartogram_ncont}{SpatialPolygonsDataFrame}(x, weight, k = 1, inplace = TRUE)

\method{cartogram_ncont}{sf}(x, weight, k = 1, inplace = TRUE)
}
\arguments{
\item{x}{a polygon or multiplogyon sf object}

\item{weight}{Name of the weighting variable in x}

\item{k}{Factor expansion for the unit with the greater value}

\item{inplace}{If TRUE, each polygon is modified in its original place, 
if FALSE multi-polygons are centered on their initial centroid}
}
\value{
An object of the same class as x with resized polygon boundaries
}
\description{
Construct a non-contiguous area cartogram (Olson 1976).
}
\examples{
library(sf)
library(cartogram)

nc = st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

# transform to NAD83 / UTM zone 16N
nc_utm <- st_transform(nc, 26916)

# Create cartogram
nc_utm_carto <- cartogram_ncont(nc_utm, weight = "BIR74")

# Plot 
par(mfrow=c(2,1))
plot(nc[,"BIR74"], main="original", key.pos = NULL, reset = FALSE)
plot(st_geometry(nc_utm), main="distorted", reset = FALSE)
plot(nc_utm_carto[,"BIR74"], add =TRUE)

}
\references{
Olson, J. M. (1976). Noncontiguous Area Cartograms. In The Professional Geographer, 28(4), 371-380.
}
