% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram_dorling.R
\name{cartogram_dorling}
\alias{cartogram_dorling}
\alias{cartogram_dorling.sf}
\alias{cartogram_dorling.SpatialPolygonsDataFrame}
\title{Calculate Non-Overlapping Circles Cartogram}
\usage{
cartogram_dorling(x, weight, k = 5, m_weight = 1, itermax = 1000)

\method{cartogram_dorling}{sf}(x, weight, k = 5, m_weight = 1, itermax = 1000)

\method{cartogram_dorling}{SpatialPolygonsDataFrame}(x, weight, k = 5, m_weight = 1, itermax = 1000)
}
\arguments{
\item{x}{a polygon or multiplogyon sf object}

\item{weight}{Name of the weighting variable in x}

\item{k}{Share of the bounding box of x filled by the larger circle}

\item{m_weight}{Circles' movements weights. An optional vector of numeric weights 
(0 to 1 inclusive) to 
apply to the distance each circle moves during pair-repulsion. A weight of 0 
prevents any movement. A weight of 1 gives the default movement distance. A 
single value can be supplied for uniform weights. A vector with length less 
than the number of circles will be silently extended by repeating the final 
value. Any values outside the range [0, 1] will be clamped to 0 or 1.}

\item{itermax}{Maximum iterations for the cartogram transformation.}
}
\value{
Non overlaping proportional circles of the same class as x.
}
\description{
Construct a cartogram which represents each geographic region 
as non-overlapping circles (Dorling 1996).
}
\examples{
library(sf)
library(cartogram)

nc = st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

# transform to NAD83 / UTM zone 16N
nc_utm <- st_transform(nc, 26916)

# Create cartogram
nc_utm_carto <- cartogram_dorling(nc_utm, weight = "BIR74")

# Plot 
par(mfrow=c(2,1))
plot(nc[,"BIR74"], main="original", key.pos = NULL, reset = FALSE)
plot(nc_utm_carto[,"BIR74"], main="distorted", key.pos = NULL, reset = FALSE)

}
\references{
Dorling, D. (1996). Area Cartograms: Their Use and Creation. In Concepts and Techniques in Modern Geography (CATMOG), 59.
}
