% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mda.R
\name{axe-mda}
\alias{axe-mda}
\alias{axe_call.mda}
\alias{axe_call.fda}
\alias{axe_env.mda}
\alias{axe_env.fda}
\alias{axe_fitted.mda}
\alias{axe_fitted.fda}
\title{Axing a mda.}
\usage{
\method{axe_call}{mda}(x, verbose = FALSE, ...)

\method{axe_call}{fda}(x, verbose = FALSE, ...)

\method{axe_env}{mda}(x, verbose = FALSE, ...)

\method{axe_env}{fda}(x, verbose = FALSE, ...)

\method{axe_fitted}{mda}(x, verbose = FALSE, ...)

\method{axe_fitted}{fda}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed mda object.
}
\description{
mda and fda objects are created from the \pkg{mda} package, leveraged to
carry out mixture discriminant analysis and flexible discriminat analysis,
respectively.
}
\examples{
\dontshow{if (rlang::is_installed("mda")) withAutoprint(\{ # examplesIf}
library(mda)

mtcars$cyl <- as.factor(mtcars$cyl)

fit <- mda(cyl ~ ., data = mtcars)
out <- butcher(fit, verbose = TRUE)

fit2 <- fda(cyl ~ ., data = mtcars)
out2 <- butcher(fit2, verbose = TRUE)

# Another mda object
data(glass)
wrapped_mda <- function(fit_fn) {
  some_junk_in_environment <- runif(1e6)
  fit <- fit_fn(Type ~ ., data = glass)
  return(fit)
}

lobstr::obj_size(wrapped_mda(mda))
lobstr::obj_size(butcher(wrapped_mda(mda)))

lobstr::obj_size(wrapped_mda(fda))
lobstr::obj_size(butcher(wrapped_mda(fda)))
\dontshow{\}) # examplesIf}
}
