% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-env-df.R
\name{btw_this.data.frame}
\alias{btw_this.data.frame}
\alias{btw_this.tbl}
\title{Describe a data frame in plain text}
\usage{
\method{btw_this}{data.frame}(
  x,
  ...,
  format = c("skim", "glimpse", "print", "json"),
  max_rows = 5,
  max_cols = 100,
  package = NULL
)

\method{btw_this}{tbl}(
  x,
  ...,
  format = c("skim", "glimpse", "print", "json"),
  max_rows = 5,
  max_cols = 100,
  package = NULL
)
}
\arguments{
\item{x}{A data frame or tibble.}

\item{...}{Additional arguments are silently ignored.}

\item{format}{One of \code{"skim"}, \code{"glimpse"}, \code{"print"}, or \code{"json"}.
\itemize{
\item \code{"skim"} is the most information-dense format for describing the data. It
uses and returns the same information as \code{\link[skimr:skim]{skimr::skim()}} but formatting as
a JSON object that describes the dataset.
\item To glimpse the data column-by-column, use \code{"glimpse"}. This is
particularly helpful for getting a sense of data frame column names,
types, and distributions, when pairings of entries in individual rows
aren't particularly important.
\item To just print out the data frame, use \code{print()}.
\item To get a json representation of the data, use \code{"json"}. This is
particularly helpful when the pairings among entries in specific rows
are important to demonstrate.
}}

\item{max_rows}{The maximum number of rows to show in the data frame. Only
applies when \code{format = "json"}.}

\item{max_cols}{The maximum number of columns to show in the data frame. Only
applies when \code{format = "json"}.}

\item{package}{The name of the package that provides the data set. If not
provided, \code{data_frame} must be loaded in the current environment, or may
also be inferred from the name of the data frame, e.g. \code{"dplyr::storms"}.}
}
\value{
A character vector containing a representation of the data frame.
Will error if the named data frame is not found in the environment.
}
\description{
Describe a data frame in plain text
}
\section{Functions}{
\itemize{
\item \code{btw_this(data.frame)}: Summarize a data frame.

\item \code{btw_this(tbl)}: Summarize a \code{tbl}.

}}
\examples{
btw_this(mtcars)

btw_this(mtcars, format = "print")

btw_this(mtcars, format = "json")

}
\seealso{
\code{\link[=btw_tool_env_describe_data_frame]{btw_tool_env_describe_data_frame()}}

Other btw formatting methods: 
\code{\link{btw_this}()},
\code{\link{btw_this.character}()},
\code{\link{btw_this.environment}()}

Other btw formatting methods: 
\code{\link{btw_this}()},
\code{\link{btw_this.character}()},
\code{\link{btw_this.environment}()}
}
\concept{btw formatting methods}
