% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_bscui_options.R
\name{set_bscui_options}
\alias{set_bscui_options}
\title{Set options of bscui widget}
\usage{
set_bscui_options(
  widget,
  show_menu,
  menu_width,
  zoom_min,
  zoom_max,
  zoom_step,
  clip,
  default_png_scale,
  selection_color,
  selection_opacity,
  selection_width,
  hover_color,
  hover_opacity,
  hover_width,
  structure_shapes,
  dblclick_timeout,
  hover_timeout,
  width,
  height
)
}
\arguments{
\item{widget}{a \code{\link{bscui}} object}

\item{show_menu}{if TRUE (default) control menu will be available}

\item{menu_width}{css width value (default: "30px")}

\item{zoom_min}{smallest zoom value (default: 0.5)}

\item{zoom_max}{largest zoom value (default: 20)}

\item{zoom_step}{zooming step: the larger the faster (default: 1.1)}

\item{clip}{if TRUE (default: FALSE), when the current zoom is 1, the viewBox
is automatically set to its original state (the drawing cannot be moved)}

\item{default_png_scale}{default value for scaling PNG export (default: 1)}

\item{selection_color}{color used to highlight selection (default: "orange")}

\item{selection_opacity}{opacity of selection highlight (default: 0.5)}

\item{selection_width}{the additional stroke width to apply on selection
(default: 4)}

\item{hover_color}{a list of colors used to highlight hovered elements
(default: \code{list(button="yellow", selectable="cyan", none="transparent")})}

\item{hover_opacity}{opacity of hovered highlight (default: 0.5)}

\item{hover_width}{the additional stroke width to apply on hover (default: 4)}

\item{structure_shapes}{SVG shapes to considered as concrete
drawing
(default:
\code{c("rect", "circle", "ellipse", "line", "polyline", "polygon", "path")}:
"text" excluded)}

\item{dblclick_timeout}{minimum time in ms between 2 independant clicks
(default: 250)}

\item{hover_timeout}{time in ms before update hovered element (default: 100)}

\item{width, height}{widget width: must be a valid CSS unit (like \code{'100\\\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}
}
\value{
The modified \code{\link{bscui}} object
}
\description{
Set options of bscui widget
}
\examples{
##################################@
### Preparing data ----

library(bscui)
library(xml2)
library(readr)
library(dplyr)

svg <- xml2::read_xml(system.file(
   "examples", "Animal_cells.svg.gz",
   package="bscui"
))
info <- readr::read_tsv(system.file(
   "examples", "uniprot_cellular_locations.txt.gz",
   package="bscui"
), col_types=strrep("c", 6)) |>
   mutate(id = sub("-", "", `Subcellular location ID`))

##################################@
### Building the figure ----

figure <- bscui(svg) |>
   set_bscui_ui_elements(
      info |>
         mutate(
            ui_type = "selectable",
            title = Name
         ) |>
         select(id, ui_type, title)
   ) |>
   set_bscui_styles(
      info |>
         filter(Name == "Cytosol") |>
         mutate(fill = "#FF7F7F") |>
         select(id, fill)
   ) |>
   set_bscui_attributes(
      info |>
         filter(Name == "Cytoskeleton") |>
         mutate(display = "none") |>
         select(id, display)
   ) |>
   set_bscui_selection("SL0188") |>
   set_bscui_options(zoom_min=1, clip=TRUE)
figure

##################################@
### Saving the figure ----

if(interactive()){
   ## Temporary directory to save example file
   tdir <- tempdir()

   ## Interactive html file
   f_path <- file.path(tdir, "figure.html")
   figure |> htmlwidgets::saveWidget(file=f_path)
   cat(f_path)

   ## PNG image
   f_path <- file.path(tdir, "figure.png")
   figure |>
      set_bscui_options(show_menu = FALSE) |>
      export_bscui_to_image(file=f_path, zoom=2)
   cat(f_path)
}
}
