% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non_central_t_distribution.R
\name{non_central_t_distribution}
\alias{non_central_t_distribution}
\alias{non_central_t_pdf}
\alias{non_central_t_lpdf}
\alias{non_central_t_cdf}
\alias{non_central_t_lcdf}
\alias{non_central_t_quantile}
\title{Noncentral T Distribution Functions}
\usage{
non_central_t_distribution(df, delta)

non_central_t_pdf(x, df, delta)

non_central_t_lpdf(x, df, delta)

non_central_t_cdf(x, df, delta)

non_central_t_lcdf(x, df, delta)

non_central_t_quantile(p, df, delta)
}
\arguments{
\item{df}{degrees of freedom (df > 0)}

\item{delta}{noncentrality parameter (delta >= 0)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Noncentral T distribution.
}
\examples{
# Noncentral T distribution with 5 degrees of freedom and noncentrality parameter 1
dist <- non_central_t_distribution(5, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
non_central_t_pdf(0, 5, 1)
non_central_t_lpdf(0, 5, 1)
non_central_t_cdf(0, 5, 1)
non_central_t_lcdf(0, 5, 1)
non_central_t_quantile(0.5, 5, 1)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/nc_t_dist.html}{Boost Documentation} for more details on the mathematical background.
}
