% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bolasso}
\alias{plot.bolasso}
\title{Plot a \code{bolasso} object}
\usage{
\method{plot}{bolasso}(x, covariates = NULL, ...)
}
\arguments{
\item{x}{An object of class \link{bolasso} or \code{bolasso_fast}.}

\item{covariates}{A subset of the covariates to plot. This should be a
vector of covariate names either as strings or bare. E.g.
\code{covariates = c("var_1", "var_2")} or \code{covariates = c(var_1, var_2)}.
This argument is optional and is \code{NULL} by default. In this case it will
plot up to 30 covariates with the largest absolute mean coefficients.}

\item{...}{Additional arguments to pass directly to \code{\link{coef}} for
objects of class \link{bolasso} or \code{bolasso_fast}.}
}
\description{
The method plots coefficient distributions for the covariates included
in the \code{bolasso} model. If there are more than 30 covariates included in
the full model, this will plot the 30 covariates with the largest
absolute mean coefficient. The user can also plot coefficient distributions
for a specified subset of covariates.
}
