% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.R
\name{normality}
\alias{normality}
\alias{print.normality}
\title{Statistical and Visual Normality Assessment}
\usage{
normality(data, x, all = FALSE, color = "#79E1BE")

\method{print}{normality}(x, ...)
}
\arguments{
\item{data}{Dataframe containing the variables to be summarized.}

\item{x}{An object of class "normality"}

\item{all}{Logical parameter that displays all row indices of values outside 95\% CI. Default: FALSE.}

\item{color}{Character string indicating color for plots. Default: "#79E1BE".}

\item{...}{Additional arguments (not used)}
}
\value{
Returns an object of class "normality" with normality statistics and ggplot objects.
}
\description{
Tests normality using sample size-appropriate methods: Shapiro-Wilk test (n less than or
equal to 50) or Kolmogorov-Smirnov test (n greater than 50) with Q-Q plots and histograms.
Evaluates skewness and kurtosis using z-score criteria based on sample size. Automatically
detects outliers and provides comprehensive visual and statistical assessment.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(normality)}: Print method for objects of class "normality".

}}
\examples{
# Simulated clinical data
clinical_df <- clinical_data()

# Normally assesment of numerical variable
normality(clinical_df, "biomarker")

# Normally assesment of numerical variable with points outside 95\% CI displayed
normality(clinical_df, "weight", all = TRUE)

}
\references{
Mishra P., Pandey C.M., Singh U., Gupta A., Sahu C., and Keshri A. Descriptive statistics
and normality tests for statistical data. Ann Card Anaesth. 2019 Jan-Mar;22(1):67-72.
doi: 10.4103/aca.ACA_157_18. PMID: 30648682; PMCID: PMC6350423.
}
