% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_simulate_list.R
\name{simulate_list}
\alias{simulate_list}
\title{Process: Simulating Fake Data}
\usage{
simulate_list(
  data,
  id = 1,
  n_params,
  n_trials,
  obj_func,
  rfun,
  iteration = 10,
  seed = 123
)
}
\arguments{
\item{data}{[data.frame] 

This data should include the following mandatory columns: 
 \itemize{
   \item "sub"
   \item "time_line" (e.g., "Block", "Trial")
   \item "L_choice"
   \item "R_choice"
   \item "L_reward"
   \item "R_reward"
   \item "sub_choose"
 }}

\item{id}{[vector]

Specifies which subject's data to use. In parameter and model recovery
 analyses, the specific subject ID is often irrelevant. Although the
 experimental trial order might have some randomness for each subject,
 the sequence of reward feedback is typically pseudo-random.

The default value for this argument is \code{NULL}. When \code{id = NULL},
 the program automatically detects existing subject IDs within the
 dataset. It then randomly selects one subject as a sample, and the
 parameter and model recovery procedures are performed based on this
 selected subject's data.
 
default: \code{id = NULL}}

\item{n_params}{[integer] 

The number of free parameters in your model.}

\item{n_trials}{[integer] 

The total number of trials in your experiment.}

\item{obj_func}{[function]

The objective function that the optimization algorithm package accepts.
 This function must strictly take only one argument, \code{params} (a vector
 of model parameters). Its output must be a single numeric value
 representing the loss function to be minimized. For more detailed
 requirements and examples, please refer to the relevant documentation 
 (
    \code{\link[binaryRL]{TD}}, 
    \code{\link[binaryRL]{RSTD}}, 
    \code{\link[binaryRL]{Utility}}
 ).}

\item{rfun}{[List]

A nested list of functions used to generate random parameter values for
 simulation. The top-level elements of the list should be named
 according to the models. Each of these elements must be a named list
 of functions, where each name corresponds to a model parameter and its
 value is the random number generation function.

e.g., \code{stats::runif}, \code{stats::rexp}}

\item{iteration}{[integer]

This parameter determines how many simulated datasets are created for 
 subsequent model and parameter recovery analyses.
 
default: \code{iteration_s = 10}}

\item{seed}{[integer] 

Random seed. This ensures that the results are 
 reproducible and remain the same each time the function is run. 
 
default: \code{seed = 123}}
}
\value{
a list with fake data generated by random free parameters
}
\description{
This function generates random input parameters for a model based on
 user-specified distributions. For example, if the first parameter,
 \code{eta}, is set to follow a uniform distribution from 0 to 1, its
 values will be randomly sampled from \code{U(0, 1)}.

You can also specify parameters to be drawn from a normal distribution. 
 For example, \code{
   eta = function() { stats::rnorm(n = 1, mean = 0.5, sd = 0.1) }
 }. 
 Make sure the last parameter, which typically represents the inverse 
 temperature parameter in the soft-max function, is sampled from an 
 exponential distribution.
}
\examples{
\dontrun{
list_simulated <- binaryRL::simulate_list(
  data = binaryRL::Mason_2024_G2,
  obj_func = binaryRL::RSTD,
  n_params = 3,
  n_trials = 360,
  rfun = list(
    etan = function() { stats::runif(n = 1, min = 0, max = 1) },
    etap = function() { stats::runif(n = 1, min = 0, max = 1) },
    tau = function() { stats::rexp(n = 1, rate = 1) }
  ),
  iteration = 10
)
}

}
