% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{panther-tree}
\alias{panther-tree}
\alias{PANTHER}
\alias{PANTHERDB}
\alias{read_panther}
\alias{read.panther}
\title{Reads PANTHER db trees}
\usage{
read_panther(x, tree.reader = ape::read.tree, ...)

read.panther(x, tree.reader = ape::read.tree, ...)
}
\arguments{
\item{x}{Character scalar. Full path to the panther file.}

\item{tree.reader}{Function that will be used to read the tree file.
It can be either \code{ape::read.tree} or \code{rncl::read_newick_phylo}.}

\item{...}{Further arguments passed to \code{\link[ape:read.tree]{ape::read.tree()}}.}
}
\value{
A list consisting of a data.frame and a \code{phylo} object. The
data.frame has the following columns:

\item{branch_length}{Numeric vector. Length of the branch to its parent node.}
\item{type}{Character vector. Can be either \code{"S"} (speciation), \code{"D"}
(duplication), or \code{"T"} (horizontal transfer).}
\item{ancestor}{Character vector. Name of the ancestor.}

The nodeids can be identified using the rownames.
}
\description{
The PANTHER Project handles a modified version of newick tree files which,
besides of the tree structure, includes the type of node and ancestor
labels. This function is a wrapper of \code{\link[ape:read.tree]{ape::read.tree()}}.
}
\examples{
path <- system.file("tree.tree", package="aphylo")
read_panther(path)

}
\seealso{
Other reading: 
\code{\link{read_nhx}()},
\code{\link{read_pli}()}
}
\concept{reading}
