% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flights_package.R
\name{as_flights_package}
\alias{as_flights_package}
\title{Generate a Data Package from `anyflights` Data}
\usage{
as_flights_package(data, name = make.names(deparse(substitute(data))))
}
\arguments{
\item{data}{A named list of dataframes outputted by 
\code{\link{anyflights}}.}

\item{name}{The desired name of the resulting package as a character string.
The package will check that the supplied package name is valid using the
regular expression \code{.standard_regexps()$valid_package_name}, and save
the output in a directory by the same name. Defaults to 
\code{make.names(deparse(substitute(data)))}.}
}
\value{
A directory containing a data-only package built around the
supplied data.
}
\description{
Generate a data-only package, including documentation, from data outputted
by the `anyflights()` function. Please do not submit the outputted package to
CRAN or similar repositories as original packages.
}
