% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_cohortMT.R
\name{summarize_cohortMT}
\alias{summarize_cohortMT}
\title{Plot summarized maintenance therapy (MT) data for a cohort}
\usage{
summarize_cohortMT(input_files_path, anc_range, unit, dose_intensity_threshold)
}
\arguments{
\item{input_files_path}{Path to folder with MT csv files (in quotes)}

\item{anc_range}{ANC target range as per the protocol: (c(lower threshold, upper threshold)). NOTE: Ensure that units are the same as unit of ANC in the input data.}

\item{unit}{Choose either "million" or "billion".
\itemize{
\item{"million" = million cells/L (x\eqn{10^{6}} cells/L or cells/\eqn{\mu}l)}
\item{"billion" = billion cells/L (x\eqn{10^{9}} cells/L or x\eqn{10^{3}} cells/\eqn{\mu}l)}
}}

\item{dose_intensity_threshold}{numeric value of reference drug dose intensity (\%). (optional)}
}
\value{
Summary graph
}
\description{
Create an integrated summary graph illustrating
weighted mean absolute neutrophil count (ANC) and dose information for each patient in the cohort.
}
\note{
\itemize{
\item{If there is only one threshold for anc_range or dose_intensity_range parameters, please specify the respective value and keep the other threshold as NA. eg : c(2000, NA), c(100, NA)}
\item{Horizontal dotted lines on the graph indicate anc_range thresholds.Red dot represents summarized overall MT data.}
}
}
\examples{
cohort_path = paste0(system.file("extdata/processed_data/", package = "allMT"), "/")
summarize_cohortMT (input_files_path = cohort_path, unit = "billion",
                    anc_range = c(0.75, 1.5), dose_intensity_threshold = c(80, 100))

\donttest{
summarize_cohortMT(input_files_path = cohort_path,
                 unit = "billion", anc_range = c(0.8, 2), dose_intensity_threshold = 150)

# As per BFM protocol (Reference PMID - 15902295):
summarize_cohortMT (input_files_path = cohort_path,
                 unit = "billion", anc_range = c(2, NA), dose_intensity_threshold = 150)

# As per St Jude protocol (Reference PMID - 15902295):
summarize_cohortMT (input_files_path = cohort_path,
                 unit = "billion", anc_range = c(0.8, 2), dose_intensity_threshold = 100)

}

}
\seealso{
\code{\link[=compare_cohorts]{compare_cohorts()}}
}
