% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padronizar_dre.R
\name{padronizar_dre}
\alias{padronizar_dre}
\title{Processa e agrega uma Demonstracao do Resultado do Exercicio (DRE) em categorias contabeis}
\usage{
padronizar_dre(df)
}
\arguments{
\item{df}{Um \code{data.frame} contendo a DRE. A primeira coluna deve corresponder aos nomes
das contas, e as colunas seguintes devem conter valores financeiros em formato de
texto (por exemplo, \code{"(45.300,50)"}).}
}
\value{
Uma lista contendo dois objetos:
\describe{
  \item{\code{agregado}}{Um \code{data.frame} com os valores financeiros agregados por categoria da DRE.}
  \item{\code{original}}{O \code{data.frame} original, com os valores convertidos e a coluna \code{Categoria} adicionada.}
}
}
\description{
Esta funcao realiza o pre-processamento de um \code{data.frame} contendo contas da Demonstracao
do Resultado do Exercicio (DRE). O procedimento envolve a normalizacao dos nomes das contas,
a conversao dos valores financeiros expressos no formato brasileiro para valores numericos
padrao e a classificacao das contas nas categorias contabeis predefinidas em \code{categorias_dre}.
}
\details{
Apos a categorizacao, os valores sao agregados por categoria, permitindo a analise consolidada
da estrutura de resultados da empresa. O objetivo e padronizar demonstracoes provenientes de
diferentes fontes, facilitando comparacoes, calculos de indicadores e analises financeiras.

A primeira coluna do \code{data.frame} deve conter os nomes das contas, enquanto as demais
colunas devem conter valores financeiros representados como texto no formato contabil brasileiro
(uso de ponto como separador de milhar e virgula como separador decimal, com parenteses
indicando valores negativos).
}
\examples{
df <- data.frame(
  Conta = c("Receita Bruta de Vendas", "ICMS", "Custo das Mercadorias Vendidas"),
  X2023 = c("100.000,00", "(15.000,00)", "(40.000,00)")
)

resultado <- padronizar_dre(df)
resultado$agregado

}
