% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl.2tsgg.R
\name{pl.2tsgg}
\alias{pl.2tsgg}
\title{Time series plot for two variables with ggplot2}
\usage{
pl.2tsgg(ts1,ts2,title,ylab)
}
\arguments{
\item{ts1}{:a time series variable or a numeric variable}

\item{ts2}{:a time series variable or a numeric variable}

\item{title}{:title for the plot}

\item{ylab}{:y-axis label}
}
\description{
Plotting two time series in one plot, with title and label. If both variables are time series object, they will be merged by time.
If both variables are not time series object, they will be merged by order. The first variable is set to be a solid line and the second variable
is set to be a dashed line. If the variables are of different type a warning message will be given.
}
\examples{
DAX <- EuStockMarkets[,1]
FTSE <- EuStockMarkets[,4]
pl.2tsgg(DAX,FTSE, "Times Series Plot of DAX and FTSE", "Index")
}
