% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair.combn.R
\name{pair.combn}
\alias{pair.combn}
\title{Determine all paired comparisons}
\usage{
pair.combn(blocks, unique = TRUE)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{unique}{Logical. Should only unique paired comparisons be returned?}
}
\value{
Returns a matrix with all paired comparisons defined by a design.
}
\description{
This function returns a matrix containing all paired comparisons defined by
a design.
}
\examples{

#' # Define 30 items divided by three triplets as blocks
blocks <- matrix(c(1:30), ncol = 3)

# Get all blocks
pair.combn(blocks)
    
}
