% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPLS_cv.R
\name{TPLS_cv}
\alias{TPLS_cv}
\title{Constructor method for fitting a cross-validation T-PLS model}
\usage{
TPLS_cv(X, Y, CVfold, NComp = 25, W = NULL, nmc = 0)
}
\arguments{
\item{X}{Numerical matrix of predictors. Typically single-trial betas where each column is a voxel and row is observation}

\item{Y}{Variable to predict. Binary 0 and 1 in case of classification, continuous variable in case of regression}

\item{CVfold}{Cross-validation testing fold information. Can either be a vector or a matrix, the latter being more general.
Vector: n-by-1 vector. Each element is a number ranging from 1 ~ numfold to identify which testing fold each observation belongs to
Matrix: n-by-numfold matrix. Each column indicates the testing data with 1 and training data as 0.
Example: For leave-one-out CV, Vector would be 1:n, Matrix form would be eye(n)
Matrix form is more general as it can have same trial be in multiple test folds}

\item{NComp}{(Optional) Number of PLS components to compute. Default is 25.}

\item{W}{(Optional) Observation weights. Optional input. By default, all observations have equal weight.
Can either be a n-by-1 vector or a n-by-nfold matrix where each column is observation weights in that CV fold}

\item{nmc}{(Optional) 'no mean centering'. See TPLS for more detail.
Turning this on will skip mean centering on all cross validation folds, so they should all be mean-centered already}
}
\value{
A TPLS_cv object that contains the following attributes. Most of the time, you won't need to access the attributes.
\itemize{
    \item \code{NComp}: The number of components you specified in the input
    \item \code{numfold}: Total number of cross-validation folds
    \item \code{CVfold}: A matrix of indicators for testing data for each cross validation fold in each column
    \item \code{cvMdls} : A vector of TPLS models, one for each fold.
}
See vignettes for tutorial
}
\description{
Constructor method for fitting a cross-validation T-PLS model
}
