% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{TCHazaRdsWindTimeSereies}
\alias{TCHazaRdsWindTimeSereies}
\title{Compute the Wind Hazards Associated Over the Period of a TCs Event at one Given Location}
\usage{
TCHazaRdsWindTimeSereies(
  outdate = NULL,
  GEO_land = NULL,
  TC,
  paramsTable,
  returnWaves = FALSE
)
}
\arguments{
\item{outdate}{array of POSITx date times to linearly interpolate TC track,optional.}

\item{GEO_land}{dataframe hazard geometry generated with land_geometry}

\item{TC}{SpatVector of Tropical cyclone track parameters}

\item{paramsTable}{Global parameters to compute TC Hazards.}

\item{returnWaves}{Return ocean wave parameters (default = FALSE)}
}
\value{
list() containing a timeseries\tabular{lll}{
   abbreviated attribute \tab description \tab units \cr
   date \tab POSIX data time object of TC or outdate if provided \tab as.POSIX \cr
   P \tab Atmospheric pressure \tab hPa \cr
   Uw \tab Meridional  wind speed \tab m/s \cr
   Vw \tab Zonal wind speed \tab m/s \cr
   Sw \tab Wind speed \tab m/s \cr
   R \tab distance to TC centre \tab m \cr
   rMax \tab radius of maximum wind \tab km \cr
   vMax \tab TC maximum velocity \tab m/s \cr
   b \tab TC wind profile exponent \tab - \cr
   CP \tab TC central Pressure \tab hPa \cr
   dPdt \tab change in TC CP per hour \tab hPa/hr \cr
   vFm \tab velocity of TC forward motion \tab m/s \cr
   Hs0 \tab Deep water significant wave height \tab m \cr
   Tp0 \tab Deep water Peak wave period \tab s \cr
   Dp0 \tab The peak direction in which wave are heading \tab deg clockwise from true north. \cr
}
}
\description{
Compute the Wind Hazards Associated Over the Period of a TCs Event at one Given Location
}
\details{
The function calculates wind speed and direction time series from a tropical cyclone track using various wind profile models.
}
\examples{
GEO_land = data.frame(dem=0,lons = 147,lats=-18,f=-4e-4,inlandD = 0)

require(terra)
TCi <- vect(system.file("extdata/YASI/YASI.shp", package="TCHazaRds"))
TCi$PRES <- TCi$BOM_PRES

paramsTable = read.csv(system.file("extdata/tuningParams/defult_params.csv",package = "TCHazaRds"))
HAZts = TCHazaRdsWindTimeSereies(GEO_land=GEO_land,TC=TCi,paramsTable = paramsTable)
main =  paste(TCi$NAME[1],TCi$SEASON[1],"at",GEO_land$lons,GEO_land$lats)
#with(HAZts,plot(date,Sw,format = "\%b-\%d \%H",type="l",main = main,ylab = "Wind speed [m/s]"))
}
