% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagpol.R
\name{lagpol}
\alias{lagpol}
\title{Lag polynomials}
\usage{
lagpol(param = NULL, s = 1, p = 1, lags = NULL, coef = NULL)
}
\arguments{
\item{param}{a vector/list of named parameters.}

\item{s}{the seasonal period, integer.}

\item{p}{the power of lag polynomial, integer.}

\item{lags}{a vector of lags for sparse polynomials.}

\item{coef}{a vector of math expressions.}
}
\value{
\code{lagpol} returns an object of class "lagpol" with the following
  components: \describe{ \item{coef}{Vector of coefficients c(coef_1, ...,
  coef_p) provided to create the lag polynomial.}

  \item{pol}{Base lag polynomial, c(1, -coef_1, ..., -coef_d).}

  \item{Pol}{Power lag polynomial when p > 1.} }
}
\description{
\code{lagpol} creates a lag polynomial of the form \eqn{(1 - coef_1 B^s - ...
- coef_d B^sd)^p}. This class of lag polynomials is defined by a vector of d
coefficients c(coef_1, ..., coef_d), the powers s and p, and a vector of k
parameters c(param_1, ..., param_k). The vector c(coef_1, ..., coef_d) is
actually a vector of math expressions to compute the value of each
coefficient in terms of the parameters.
}
\examples{
lagpol(param = c(phi = 0.8) )
lagpol(param = c(phi1 = 1.2, phi2 = -0.6), s = 4)
lagpol(param = c(delta = 1), p = 2)

}
